/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "html/color.hh"
#include "html/font.hh"
#include "html/genAttr.hh"
#include "html/size.hh"
#include "html/style.hh"
#include "html/writer.hh"

using namespace html;

//======================================  Default Constructor
StyleClass::StyleClass(void) {}

//======================================  Destructor
StyleClass::~StyleClass(void) {
}

//======================================  Write out attribute list
void 
StyleClass::putAttr(writer& w) const {
    for (const_attr_iter i=begin() ; i != end() ; i++) {
	w.text(i->first);
	if ((i->second)->hasArg()) {
	    w.text(": ");
	    (i->second)->putAttr(w);
	}
        w.text("; ");
    }
}  


//======================================  Set the color attribute
StyleClass& 
StyleClass::setColor(const color& c) {
    addAttr("color", c);
    return *this;
}

//======================================  Set the font face
StyleClass& 
StyleClass::setFace(const font& f) {
    addAttr("font-family", f);
    return *this;
}

//======================================  Set the font size
StyleClass& 
StyleClass::setSize(const size& sz) {
    addAttr("font-size", sz);
    return *this;
}

//======================================  set the font weight
StyleClass& 
StyleClass::setWeight(const std::string& c) {
    addAttr("font-weight", genAttr(c));
    return *this;
}

//======================================  Default Constructor
style::style(void) {
}

//======================================  Default Constructor
style::~style(void) {
}

//======================================  Add a style class to the dictionary
void 
style::addClass(const std::string& name, const StyleClass& c) {
    mDict.insert(StyleDict::value_type(name, c));
}

//======================================  Write out the style 
void 
style::write(writer& w) const {
    if (mDict.empty()) return;
    w.tag("style");
    for (const_style_iterator i=mDict.begin(); i != mDict.end(); ++i) {
        w.text(std::string(".")+i->first+" { ");
	(i->second).putAttr(w);
	w.text(" } ");
    }
    w.endTag("style");
}

