/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "html/font.hh"
#include "html/writer.hh"
#include <string>

//======================================  Construct a default font specifier
html::font::font(void)
{}

//======================================  Specify a font
html::font::font(const std::string& Face)
  : mFace(Face)
{}

//======================================  Font destructor
html::font::~font(void) {}

//======================================  Clone a font specifier
html::font*
html::font::clone(void) const {
    return new font(*this);
}

//======================================  Test for default font.
bool 
html::font::isDefault(void) const {
    return mFace.empty();
}

//======================================  Print attribute list
void 
html::font::putAttr(writer& w) const {
    w.text(std::string("\"") + mFace + "\"");
}

//======================================  Set font to default.
void 
html::font::setDefault(void) {
    mFace.erase();
}

//======================================  Set font.
void 
html::font::setFace(const std::string& name) {
    mFace = name;
}
