/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_BOOLATTR_HH
#define HTML_BOOLATTR_HH

#include "html/Attrib.hh"
#include <string>

namespace html {
  class writer;


  /**  Generic boolean attribute class.
    *  @brief Boolean attribute class.
    *  @author John Zweizig
    *  @version 1.1; Last modified March 4, 2008
    *  @ingroup IO_html
    */
  class boolAttr : public attrib {
  public:
    /**  Construct a boolean attribute and optionally initialize the value.
      *  @brief Boolean attribute constructor.
      *  @param value Initial value for boolean attribute.
      */
    boolAttr(bool value=true);

    /**  Destroy a boolean attribute.
      *  @brief Destructor.
      */
    ~boolAttr(void);

    /**  Make an identical copy of the boolean attribute.
      *  @brief Clone attribute.
      *  @return Pointer to the cloned \c boolAttr object.
      */
    boolAttr* clone(void) const;

    /**  Test whether the alignment is the default value.
      *  @return true if default alignment.
      */
    bool isDefault(void) const;

    /**  Boolean attributes (keywords) have no argument. The attribute
      *  is therefore written as a name only.
      *  @brief Has argument test.
      *  @return Always false.
      */
    bool hasArg(void) const;

    /**  Write the attribute to the specified html writer.
      *  @brief Write the alignment.
      *  @param w Html writer reference.
      */
    void putAttr(writer& w) const;

    /**  Set the boolean argument.
      *  @brief Set the value.
      *  @param value Attribute value.
      */
    void setValue(bool value=true);

    /**  Test whether this attribute is equal to the argument.
      *  @brief Compare operator.
      *  @param x boolAttr object to be compared
      *  @return True if this attribute is equal to the argument.
      */
    bool operator==(const boolAttr& x) const;

  private:
    bool mValue;
  };

}

#endif //  HTML_BOOLATTR_HH
