/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef SWAPFRAME_HH
#define SWAPFRAME_HH

/**  The SwapFrame class performs a byte-swap of all data in a frame 
  *  stored in memory. 
  *  \attention Note that it is unlikely that this class works on 
  *  frames later than frame spec V4. This class should be rewritten 
  *  using the \c FrameF class.
  *  @author John Zweizig
  *  @version 1.1; Last major modification February 12, 2002
  *  @ingroup IO_futils
  */
class SwapFrame {
public:
    /**  Construct a frame swapper. Determine the hardware byte ordering at
      *  run-time.
      *  @brief Constructor.
      */
    SwapFrame(void);

    /**  Destroy a frame swapper.
      *  @brief Destructor.
      */
    ~SwapFrame(void);

    /**  Swap the frame contents.
      *  @brief Swap the frame.
      *  @param p   Pointer to an in-memory frame.
      *  @param len Length of in-memory frame.
      */
    void Swap(char* p, int len);

private:
    enum wType {
	kNone = 0,
	kChar,
	kString,
	kShort,
	kInt,
	kDouble,
	kPtr
    };

    void SwapString(int N=1);
    void SwapShort(int N=1);
    void SwapInt(int N=1);
    void SwapDouble(int N=1);
    short SwapHdr(void);
    bool procFileHdr(void);
    void procSH(void);
    void procSE(void);
    void procVect(void);
    void Bump(int nBytes) {mPtr += nBytes; mLeft -= nBytes;}

#define MAXID     32
#define MAXTABLE 128

private:
    bool  mBigEnd;    // byte ordering of the present machine.
    char* mPtr;
    int   mLeft;
    int*  mTable[MAXID];
    int   mLastID;
    int   mVectID;
};

#endif // SWAPFRAME_HH
