#ifndef __CINT__
#include <iostream>
#include "evalgui.cxx"
#include "TInterpreter.h"
#include "TSeries.hh"
#include "FSeries.hh"
#include "FSpectrum.hh"
#include "Dacc.hh"
Dacc In;
void Spectrum(FSpectrum* x);
void TPlot(TSeries* x);
#endif

TSeries C1, C2, C3, C4, C5, C6, C7, C8, Result;

void
eval(const char* initfile=0) {
    cout << "eval.C - Evaluate and display a Time series formula" << endl;
    cout << " " << endl;
    cout << "This macro evaluates a Time series formula and displays it" << endl;
    cout << "in either the time or frequency domain. The expression to" << endl;
    cout << "display is specified in the 'Evaluate:' box. The channels" << endl;
    cout << "which may be used in the expression are specified in the" << endl;
    cout << "Channel 1 .. 8 windows and are referred to in the expression" << endl;
    cout << "as C1 .. C8 (case sensitive). Data are accumulated over" << endl;
    cout << "a time period specified in the 'Time:' box before being" << endl;
    cout << "displayed. The result is displayed in the Frequency domain" << endl;
    cout << "if the 'Frequency' box is checked. Successive time" << endl;
    cout << "intervals will be averaged in the frequency domain" << endl;
    cout << "if the 'Accumulate' box is checked. Changes made to the" << endl;
    cout << "parameters do not affect the running mode until the Reset" << endl;
    cout << "button is pushed. " << endl;
    cout << " " << endl;
    cout << "Notes:" << endl;
    cout << "1) Consult the TSeries class definition for all the " << endl;
    cout << "   available operations on time series." << endl;
    cout << " " << endl;

    EvalPanel* x = new EvalPanel(initfile);
    TProcessEventTimer* t = new TProcessEventTimer(500);

    TSeries* tsList[8] = {&C1, &C2, &C3, &C4, &C5, &C6, &C7, &C8};

    char* nmList[8];
    for (int i=0 ; i<8 ; i++) {
        nmList[i] = new char[40];
	*nmList[i] = 0;
	tsList[i]->Clear();
	tsList[i]->setData(Time(0), Interval(0.0), (float*)0, 4096);
	tsList[i]->Clear();
    }

    char cmd[1024];
    FSpectrum fDisplay, fTemp;
    while (x->run()) {
        x->clearChange();
        double ticks = x->getTime();
        for (int i=0 ; i<8 ; i++) {
	    if (*nmList[i]) In.rmChannel(nmList[i]);
	    strncpy(nmList[i], x->getChannel(i), 40);
	    if (*nmList[i] == ' ') *nmList[i] = 0;
	    if (*nmList[i]) In.addChannel(nmList[i], 0, tsList+i);
	}
	if (*(x->getEval()) == 0) cmd[0] = 0;
	else {
	    sprintf(cmd, "Result = %s;", x->getEval());
	}
	bool fDomain = x->getFdomain();
	bool Accum = x->getAccum();
	cout << "Evaluating: " << cmd << endl;
	cout << "Time Slice: " << ticks << " seconds." << endl;
	if (fDomain) cout << "Frequency Domain" << endl;
	if (Accum)   cout << "Accumulating" << endl;
	for (int i=0 ; i<8 ; i++) {
	    if (*nmList[i]) {
	        cout << "Channel " << i+1 << " at " << (int)tsList[i] 
		     << " filled from " << nmList[i] << endl;
	    }
	}

	TPad* myPad = x->getOutPad();
	float NAcc = 0;
	Interval StepTime(ticks);
        while(!x->change()) {
	    In.fillData(StepTime);
	    if (*cmd) {
	      gInterpreter->ProcessLine(cmd);
	    }
	    myPad->cd();
	    if (Result.getNSample() == 0) continue;
	    if (fDomain) {
	        if (Accum) {
		    if (NAcc == 0.0) {
			fDisplay  = FSpectrum(FSeries(Result));
		    } else {
		        fDisplay += FSpectrum(FSeries(Result));
		    }
		    NAcc += 1.0;
		    fTemp = fDisplay;
		    fTemp *= 1.0/NAcc;
		    Spectrum(fTemp);
		} else {
		    Spectrum(FSeries(Result));
		}
	    } else {
	        TPlot(&Result);
	    }
	}
    }
    delete x;
    delete t;
}
