#ifndef LSCPDBACKOUT_HH
#define LSCPDBACKOUT_HH

#include "FilterDB.hh"
#include <string>

class DynConfig;

class LscPdBackout {
public:
  LscPdBackout(const char* ifo, const char* port, int pd=-1);
  void setCalibrate(DynConfig& cal);
  void setFilterDB(const std::string& file);
  TSeries getPdQ(const TSeries& PortQ, const TSeries& PortI);
  TSeries getPdI(const TSeries& PortQ, const TSeries& PortI);
  std::string getBaseName(void) const;
  std::string getChannelI(void) const;
  std::string getChannelQ(void) const;
  const char* getIfo(void) const;

private:
  std::string mIfo;
  std::string mPort;
  int         mPD;
  double      mPhase;
  double      mQGain;
  double      mIGain;
  double      mQOffset;
  double      mIOffset;
  double      mLscPi;
  FilterDB    mFiltDB;
  IIRFilter   mPdQFm;
  IIRFilter   mPdIFm;
};

inline std::string
LscPdBackout::getBaseName(void) const {
    return mIfo + ":LSC-" + mPort;
}

inline std::string
LscPdBackout::getChannelI(void) const {
    return getBaseName() + "_I";
}

inline std::string
LscPdBackout::getChannelQ(void) const {
    return getBaseName() + "_Q";
}

inline const char*
LscPdBackout::getIfo(void) const {
    return mIfo.c_str();
}

#endif // ASPDBACKOUT_HH
