//
//     DMTifc is an interface of a C++ monitor class to a series of 
//     external C functions. The monitor method map reasonably directly 
//     onto the DMTifc functions.
//
#include "DMTBase.hh"
#include "DMTifc.h"

class DMT_CTemplate : public DMTBase {
  public:
    DMT_CTemplate(int argc, const char *argv[]);
    ~DMT_CTemplate(void);
    void ProcessFrame(DMTBase::frame_ptr_type frame);
};

//
//    Generate a main function
EXECDMT(DMT_CTemplate)

//
//    Class Constructor.
//    Monitor initialization is provided by the function DMT_Initialize(),
//    a user provided function.
//
DMT_CTemplate::DMT_CTemplate(int argc, const char *argv[]) :
DMTBase(argc,argv)
{
    DMT_Initialize(argc, argv);
}

//
//   Class Destructor
//
DMT_CTemplate::~DMT_CTemplate(void) {
    DMT_Halt();
}

//
//   User data frame processing function.
//
//   A user data frame processing function DMT_Frame is provided by the
//   user with an interface as defined in DMTifc.h. The difference between
//   FCL and FrameCPP is assumed to be handled by the user.
//
void DMT_CTemplate::ProcessFrame(DMTBase::frame_ptr_type frame) {
#ifndef FCPP_SHARED_PTRS
    DMT_Frame(frame);
#else
    DMT_Frame(frame.get());
#endif
}
