
#include "mmstream.hh"
#include "fdstream.hh"
#include "Time.hh"
#include "Interval.hh"
#include "goption.hh"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <typeinfo>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>

   using namespace std;
   using namespace gdsbase;

   const int N = 1024*1024;	// Number of elements
   const int w = 20;		// Element size
   const int M = 8*1024;	// Block size
   const char* filename = "test.file";

   string elapsed (const Time& start, const Time& stop) 
   {
      Interval dT = stop - start;
      char buf[256];
      if (dT < Interval (1.0)) {
         sprintf (buf, "(%g ms) ", 1000. * (double)dT);
      }
      else {
         sprintf (buf, "(%g s) ", (double)dT);
      }
      return buf;
   }

   string streamname (const char* p) 
   {
      string s (p);
      string::size_type pos = s.find ("::");
      if (pos != string::npos) {
         s.erase (0, pos + 2);
      }
      pos = s.find ("<");
      if (pos != string::npos) {
         s.erase (pos);
      }
   #ifdef __GNUG__
      pos = s.find ("basic");
      if (pos != string::npos) {
         s.erase (0, pos);
      }
      pos = s.find ("stream");
      if (pos != string::npos) {
         s.erase (pos + 6);
      }
      if (!s.empty() && isdigit(s[0])) {
         s.erase (0, 1);
      }
   #endif
      while (s.size() < 16) {
         s += " ";
      }
      return s;
   }

#ifdef __GNU_STDC_OLD
template <class _Stream>
   class openstream {
   public:
      static void open (_Stream& s, const char* filename) {
         s.open (filename); }
   };
template<>
   class openstream <fstream> {
   public:
      static void open (fstream& s, const char* filename) {
         s.open (filename, ios::in | ios::out); }
   };
#endif

template <class tst_istream, class tst_ostream, class tst_stream>
   int test (const char* filename)
   {
      Time start;
      Time stop;
      // stream
      {
         cout << streamname (typeid(tst_stream).name()) << 
            ": generate test file" << endl;
         start = Now();
         ofstream out (filename);
         for (int i = 0; i < N; ++i) {
            out << setw (w) << i;
         }
         out.close();
         stop = Now();
         cout << streamname (typeid(tst_stream).name()) << 
            ": " << elapsed (start, stop) << 
            "test file ok" << endl;
      }
      // mmstream input test
      {
         // sequential read test
         start = Now();
         tst_istream inp (filename);
         bool err = false;
         for (int i = 0; i < N; ++i) {
            if (!inp) {
               err = true;
               break;
            }
            int j = 0;
            inp >> j;
            if (j != i) {
               err = true;
               break;
            }
         }
         inp.close();
         stop = Now();
         if (err) {
            cerr <<  streamname (typeid(tst_istream).name()) << 
               ": sequential read test failed" << endl;
            return 1;
         }
         else {
            cout <<  streamname (typeid(tst_istream).name()) << 
               ": " << elapsed (start, stop) << 
               "sequential read test ok" << endl;
         }
      
         // random read test
         start = Now();
         inp.open (filename);
         err = false;
         for (int i = 0; i < N; ++i) {
            int r = random() % N;
         #ifdef __GNUG__
            inp.clear();
         #endif
            inp.seekg (r * w);
            // cout << "2 good=" << inp.good() << " eof=" << inp.eof() <<
               // " fail=" << inp.fail() << " bad=" << inp.bad() << endl;
            if (!inp) {
               cerr << "!inp" << endl;
               err = true;
               break;
            }
            int j = 0;
            inp >> j;
            if (j != r) {
               cerr << "random " << r << " " << j << " " << i << endl;
               err = true;
               break;
            }
         }
         inp.close();
         stop = Now();
         if (err) {
            cerr <<  streamname (typeid(tst_istream).name()) << 
               ": random read test failed" << endl;
            return 1;
         }
         else {
            cout <<  streamname (typeid(tst_istream).name()) << 
               ": " << elapsed (start, stop) << 
               "random read test ok" << endl;
         }
      }
   
      // mmstream output test
      {
         // sequential write test
         start = Now();
         tst_ostream out (filename);
         bool err = false;
         for (int i = 0; i < N; ++i) {
            if (!out) {
               err = true;
               break;
            }
            out << setw (w) << (N - 1 - i);
         }
         if (err) {
            cerr <<  streamname (typeid(tst_ostream).name()) << 
               ": sequential write test failed(1)" << endl;
            return 1;
         }
         out.close();
         stop = Now();
      
         tst_stream io;
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
          openstream<tst_stream>::open (io, filename);
      #endif
         for (int i = 0; i < N; ++i) {
            if (!io) {
               err = true;
               break;
            }
            int j = 0;
            io >> j;
            if (j != (N - 1 - i)) {
               err = true;
               break;
            }
         }
         if (err) {
            cerr <<  streamname (typeid(tst_ostream).name()) << 
               ": sequential write test failed(2)" << endl;
            return 1;
         }
         else {
            cout <<  streamname (typeid(tst_ostream).name()) << 
               ": " << elapsed (start, stop) << 
               "sequential write test ok" << endl;
         }
         io.close();
      
         // seek/write test
         if (typeid (tst_ostream) == typeid (mm_ostream)) {
            start = Now();
            out.open (filename);
            err = false;
            out.seekp (0, ios_base::end);
            for (int i = 0; i < N; ++i) {
               if (!out) {
                  err = true;
                  break;
               }
               out.seekp (-w, ios_base::cur);
               out << setw (w) << (N - 1 - i);
               out.seekp (-w, ios_base::cur);
            }
            if (err) {
               cerr <<  streamname (typeid(tst_ostream).name()) << 
                  ": seek/write test failed(1)" << endl;
               return 1;
            }
            out.close();
            stop = Now();
         #ifndef __GNU_STDC_OLD
            io.open (filename);
         #else
             openstream<tst_stream>::open (io, filename);
         #endif
            for (int i = 0; i < N; ++i) {
               if (!io) {
                  err = true;
                  break;
               }
               int j = 0;
               io >> j;
               if (j != i) {
                  err = true;
                  break;
               }
            }
            if (err) {
               cerr <<  streamname (typeid(tst_ostream).name()) << 
                  ": seek/write test failed(2)" << endl;
               exit(0); 
               return 1;
            }
            else {
               cout <<  streamname (typeid(tst_ostream).name()) << 
                  ": " << elapsed (start, stop) << 
                  "seek/write test ok" << endl;
            }
         }
      }
   
      // mmstream input/output test
      if (typeid (tst_ostream) == typeid (mm_ostream)) {
         // sequential write&verify test
         start = Now();
         tst_stream io;
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
         openstream<tst_stream>::open (io, filename);
      #endif
         bool err = false;
         for (int i = 0; i < N; ++i) {
            if (!io) {
               err = true;
               break;
            }
            io << setw (w) << (N - 1 - i);
            int j = 0;
            io >> j;
            if (j != (N - 1 - i)) {
               err = true;
               break;
            }
         }
         io.close();
         stop = Now();
         if (err) {
            cerr << streamname (typeid(tst_stream).name()) << 
               ": sequential write & verify test failed" << endl;
            return 1;
         }
         else {
            cout << streamname (typeid(tst_stream).name()) << 
               ": " << elapsed (start, stop) << 
               "sequential write & verify test ok" << endl;
         }
      
         // random write&verify test
         start = Now();
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
         openstream<tst_stream>::open (io, filename);
      #endif
         err = false;
         for (int i = 0; i < N; ++i) {
            if (!io) {
               err = true;
               break;
            }
            int r = random() % N;
         #ifdef __GNUG__
            io.clear();
         #endif
            io.seekg (r * w);
            io.seekp (r * w);
            io << setw (w) << i;
            int j = 0;
            io >> j;
            if (j != i) {
               err = true;
               break;
            }
         }
         io.close();
         stop = Now();
         if (err) {
            cerr << streamname (typeid(tst_stream).name()) << 
               ": random write & verify test failed" << endl;
            return 1;
         }
         else {
            cout << streamname (typeid(tst_stream).name()) << 
               ": " << elapsed (start, stop) << 
               "random write & verify test ok" << endl;
         }
      }
   
      // mmstream block write test
      {
         bool err = false;
         int* inp = new int [M / sizeof(int)];
         int* out = new int [M / sizeof(int)];
         for (int j = 0; j < M / (int)sizeof(int); ++j) {
            inp[j] = j;
         }
         start = Now();
         tst_stream io;
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
         openstream<tst_stream>::open (io, filename);
      #endif
         for (int i = 0; i < (N * w) / M; ++i) {
            io.write ((const char*) inp, M);
            if (!io) {
               cerr << "!io" << endl;
               err = true;
               break;
            }
         }
         if (err) {
            delete [] inp;
            delete [] out;
            cerr << streamname (typeid(tst_stream).name()) << 
               ": block read test failed(1)" << endl;
            return 1;
         }
         io.close();
         stop = Now();
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
         openstream<tst_stream>::open (io, filename);
      #endif
         for (int i = 0; i < (N * w) / M; ++i) {
            io.read ((char*) out, M);
            if (!io) {
               cerr << "!io" << endl;
               err = true;
               break;
            }
            for (int j = 0; j < M / (int)sizeof(int); ++j) {
               if (inp[j] != out[j]) {
                  cerr << "<> " << i << " " << j << endl;
                  err = true;
                  break;
               }
            }
            if (err) 
               break;
         }
         delete [] inp;
         delete [] out;
         if (err) {
            cerr << streamname (typeid(tst_stream).name()) << 
               ": block write test failed(2)" << endl;
            return 1;
         }
         else {
            cout << streamname (typeid(tst_stream).name()) << 
               ": " << elapsed (start, stop) << 
               "block write test ok" << endl;
         }
      }
   
      // mmstream block read test
      {
         bool err = false;
         int* inp = new int [M / sizeof(int)];
         int* out = new int [M / sizeof(int)];
         for (int j = 0; j < M / (int)sizeof(int); ++j) {
            inp[j] = j;
         }
         start = Now();
         tst_stream io;
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
         openstream<tst_stream>::open (io, filename);
      #endif
         for (int i = 0; i < (N * w) / M; ++i) {
            io.read ((char*) out, M);
            if (!io) {
               cerr << "!io" << endl;
               err = true;
               break;
            }
            for (int j = 0; j < M / (int)sizeof(int); ++j) {
               if (inp[j] != out[j]) {
                  cerr << "<> " << i << " " << j << endl;
                  err = true;
                  break;
               }
            }
            if (err) 
               break;
         }
         io.close();
         stop = Now();
         delete [] inp;
         delete [] out;
         if (err) {
            cerr << streamname (typeid(tst_stream).name()) << 
               ": block read test failed" << endl;
            return 1;
         }
         else {
            cout << streamname (typeid(tst_stream).name()) << 
               ": " << elapsed (start, stop) << 
               "block read test ok" << endl;
         }
      }
   
      // mmstream block write/read test
      if (typeid (tst_ostream) == typeid (mm_ostream)) {
         bool err = false;
         int* inp = new int [M / sizeof(int)];
         int* out = new int [M / sizeof(int)];
         start = Now();
         tst_stream io;
      #ifndef __GNU_STDC_OLD
         io.open (filename);
      #else
         openstream<tst_stream>::open (io, filename);
      #endif
         for (int i = 0; i < (N * w) / M; ++i) {
            for (int j = 0; j < M / (int)sizeof(int); ++j) {
               inp[j] = random();
            }
            io.write ((const char*) inp, M);
            io.read ((char*) out, M);
            if (!io) {
               cerr << "!io" << endl;
               err = true;
               break;
            }
            for (int j = 0; j < M / (int)sizeof(int); ++j) {
               if (inp[j] != out[j]) {
                  cerr << "<> " << i << " " << j << endl;
                  err = true;
                  break;
               }
            }
            if (err) 
               break;
         }
         io.close();
         stop = Now();
         delete [] inp;
         delete [] out;
         if (err) {
            cerr << streamname (typeid(tst_stream).name()) << 
               ": block write/read test failed" << endl;
            return 1;
         }
         else {
            cout << streamname (typeid(tst_stream).name()) << 
               ": " << elapsed (start, stop) << 
               "block write/read test ok" << endl;
         }
      }
   
      cout << streamname (typeid(tst_stream).name()) << 
         ":  all tests ok" << endl;
      remove (filename);
      return 0;
   }


template <class tst_stream>
   int sequential_readtest (const char* filename, int bsize, int bufsize = 0)
   {
      char* blk = new char [bsize * 1024];
      Time start = Now();
      tst_stream inp;
   #ifndef __GNU_STDC_OLD
      if (bufsize > 0) inp.rdbuf()->pubsetbuf (0, bufsize * 1024);
   #endif
      inp.open (filename);
      //inp.rdbuf()->pubsetbuf (0, bsize*1024);
      int i = 0;
      while (inp) {
         inp.read (blk, bsize * 1024);
         if (inp) ++i;
      }
      inp.close();
      Time stop = Now();
      if (i <= 0) {
         cerr << streamname (typeid(tst_stream).name()) << 
            ": sequential block read test failed" << endl;
         return 1;
      }
      else {
         double rate = (double)(i*bsize) / (stop - start);
         cout << streamname (typeid(tst_stream).name()) << 
            ": " << elapsed (start, stop) << 
            "sequential block read test ok " << rate << " kB/s" << endl;
      }
      delete blk;
      return 0;
   }


template <class tst_stream>
   int random_readtest (const char* filename, int bsize, int bufsize = 0)
   {
      char* blk = new char [bsize * 1024];
      Time start = Now();
      tst_stream inp;
   #ifndef __GNU_STDC_OLD
      if (bufsize > 0) inp.rdbuf()->pubsetbuf (0, bufsize * 1024);
   #endif
      inp.open (filename);
      //inp.rdbuf()->pubsetbuf (0, bsize*1024);
      int i = 0;
      inp.seekg (0, ios_base::end);
      int num = inp.tellg() / (bsize * 1024);
      for (int j = 0; j < num; ++j) {
         int r = random() % num;
      #ifdef __GNUG__
         inp.clear();
      #endif
         inp.seekg (r * bsize * 1024);
         inp.read (blk, bsize * 1024);
         if (inp) ++i;
      }
      inp.close();
      Time stop = Now();
      if (i <= 0) {
         cerr << streamname (typeid(tst_stream).name()) << 
            ": random block read test failed" << endl;
         return 1;
      }
      else {
         double rate = (double)(i*bsize) / (stop - start);
         cout << streamname (typeid(tst_stream).name()) << 
            ": " << elapsed (start, stop) << 
            "random block read test ok " << rate << " kB/s" << endl;
      }
      delete blk;
      return 0;
   }


   int main (int argc, char** argv)
   {
      // parse cmd line arguments
      vector<string> filenames;
      option_string opt (argc, argv, "hfr:b:RB:");
      if (opt.opt ('h')) {
         cout << "usage: streamtest [-f][-r 'file' [-R][-b size]]" << endl;
         cout << "       -f : use fstream" << endl;
         cout << "       -r 'file' : read file" << endl;
         cout << "       -R : random reads" << endl;
         cout << "       -b 'size' : read size in kB (default 8)" << endl;
         exit (0);
      }
      bool usefstream = opt.opt ('f');
      bool randomread = opt.opt ('R');
      string filenam;
      bool doread = opt.getOpt ('r', filenam);
      int bsize = 8;
      opt.getOpt ('b', bsize);
      int bufsize = 0;
      opt.getOpt ('b', bufsize);
      if (bsize <= 0) bsize = 8;
   
      int ret = 0;
      if (doread) {
         if (randomread) {
            if (usefstream) {
               ret = random_readtest<ifstream> (filenam.c_str(), bsize, bufsize);
            } 
            else {
               ret = random_readtest<mm_istream> (filenam.c_str(), bsize);
            }
         }
         else {
            if (usefstream) {
               ret = sequential_readtest<ifstream> (filenam.c_str(), bsize, bufsize);
            } 
            else {
               ret = sequential_readtest<mm_istream> (filenam.c_str(), bsize);
            }
         }
      }
      else {
         if (usefstream) {
            ret = test<ifstream, ofstream, fstream> (filename);
         } 
         else {
            ret = test<mm_istream, mm_ostream, mm_stream> (filename);
         }
      }
      return ret;
   }
