#!/usr/bin/env python
###############################################################################
# $Id$
#
# Project:  GDAL/OGR Test Suite
# Purpose:  Test basic read support for all datatypes from a HFA file.
# Author:   Frank Warmerdam <warmerdam@pobox.com>
#
###############################################################################
# Copyright (c) 2003, Frank Warmerdam <warmerdam@pobox.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
###############################################################################

import sys

sys.path.append('../pymod')

from osgeo import gdal
import gdaltest

###############################################################################
# When imported build a list of units based on the files available.

gdaltest_list = []

init_list = [
    ('byte.img', 1, 4672, None),
    ('int16.img', 1, 4672, None),
    ('uint16.img', 1, 4672, None),
    ('int32.img', 1, 4672, None),
    ('uint32.img', 1, 4672, None),
    ('float32.img', 1, 4672, None),
    ('float64.img', 1, 4672, None),
    ('utmsmall.img', 1, 50054, None),
    ('2bit_compressed.img', 1, 11918, None)]


###############################################################################
# Test bugfix for https://oss-fuzz.com/v2/testcase-detail/6053338875428864

def hfa_read_completedefn_recursion():

    with gdaltest.error_handler():
        gdal.Open('data/hfa_completedefn_recursion.img')
    return 'success'


for item in init_list:
    ut = gdaltest.GDALTest('HFA', item[0], item[1], item[2])
    if ut is None:
        print('HFA tests skipped')
        sys.exit()
    gdaltest_list.append((ut.testOpen, item[0]))


gdaltest_list.append((hfa_read_completedefn_recursion))

if __name__ == '__main__':

    gdaltest.setup_run('hfa_read')

    gdaltest.run_tests(gdaltest_list)

    gdaltest.summarize()
