/* Header file for misc range functions. -*- C++ -*-
   Copyright (C) 2017-2019 Free Software Foundation, Inc.
   Contributed by Aldy Hernandez <aldyh@redhat.com>.

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 3, or (at your option) any later
version.

GCC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#ifndef GCC_RANGE_H
#define GCC_RANGE_H

value_range_base range_zero (tree type);
value_range_base range_nonzero (tree type);
value_range_base range_intersect (const value_range_base &,
				  const value_range_base &);
value_range_base range_union (const value_range_base &,
			      const value_range_base &);
value_range_base range_invert (const value_range_base &);
value_range_base range_positives (tree type);
value_range_base range_negatives (tree type);
#endif // GCC_RANGE_H
