/* do not edit automatically generated by mc from SymbolKey.  */
/* SymbolKey.def binary tree operations for storing symbols.

Copyright (C) 2001-2022 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_SymbolKey_H)
#   define _SymbolKey_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GNameKey.h"

#   if defined (_SymbolKey_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#   define SymbolKey_NulKey 0
#if !defined (SymbolKey_SymbolTree_D)
#  define SymbolKey_SymbolTree_D
   typedef void *SymbolKey_SymbolTree;
#endif

typedef struct SymbolKey_IsSymbol_p SymbolKey_IsSymbol;

typedef struct SymbolKey_PerformOperation_p SymbolKey_PerformOperation;

typedef unsigned int (*SymbolKey_IsSymbol_t) (unsigned int);
struct SymbolKey_IsSymbol_p { SymbolKey_IsSymbol_t proc; };

typedef void (*SymbolKey_PerformOperation_t) (unsigned int);
struct SymbolKey_PerformOperation_p { SymbolKey_PerformOperation_t proc; };


/*
   InitTree - Initializes a SymbolTree pointed to by t.
*/

EXTERN void SymbolKey_InitTree (SymbolKey_SymbolTree *t);

/*
   KillTree - Destroys the SymbolTree pointed to by t.
*/

EXTERN void SymbolKey_KillTree (SymbolKey_SymbolTree *t);

/*
   GetSymKey - Searches the SymbolTree t for an entry NameKey. If
               found then the SymKey is returned. NulKey = not found.
*/

EXTERN unsigned int SymbolKey_GetSymKey (SymbolKey_SymbolTree t, NameKey_Name NameKey);

/*
   PutSymKey - Puts an symbol entry NameKey in the SymbolTree t.
               SymKey is the value stored with NameKey.
*/

EXTERN void SymbolKey_PutSymKey (SymbolKey_SymbolTree t, NameKey_Name NameKey, unsigned int SymKey);

/*
   DelSymKey - Deletes a symbol entry NameKey in the SymbolTree t.
*/

EXTERN void SymbolKey_DelSymKey (SymbolKey_SymbolTree t, NameKey_Name NameKey);

/*
   IsEmptyTree - returns true if SymbolTree, t, is empty.
*/

EXTERN unsigned int SymbolKey_IsEmptyTree (SymbolKey_SymbolTree t);

/*
   DoesTreeContainAny - returns true if SymbolTree, t, contains any
                        symbols which in turn return true when procedure,
                        P, is called with a symbol as its parameter.
*/

EXTERN unsigned int SymbolKey_DoesTreeContainAny (SymbolKey_SymbolTree t, SymbolKey_IsSymbol P);

/*
   ForeachNodeDo - for each node in SymbolTree, t, a procedure, P,
                   is called with the node symbol as its parameter.
                   It traverse the tree in order.
*/

EXTERN void SymbolKey_ForeachNodeDo (SymbolKey_SymbolTree t, SymbolKey_PerformOperation P);

/*
   ContainsSymKey - return TRUE if tree, t, contains an entry for, NameKey.
*/

EXTERN unsigned int SymbolKey_ContainsSymKey (SymbolKey_SymbolTree t, NameKey_Name NameKey);

/*
   NoOfNodes - returns the number of nodes in the tree t.
*/

EXTERN unsigned int SymbolKey_NoOfNodes (SymbolKey_SymbolTree t, SymbolKey_IsSymbol condition);

/*
   ForeachNodeConditionDo - traverse the tree t and for any node which satisfied
                            condition call P.
*/

EXTERN void SymbolKey_ForeachNodeConditionDo (SymbolKey_SymbolTree t, SymbolKey_IsSymbol condition, SymbolKey_PerformOperation P);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
