(* (c) Microsoft Corporation 2005-2007.  *)

module Microsoft.FSharp.Compatibility.OCaml.Sys
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives
open Microsoft.FSharp.Idioms
open Microsoft.FSharp.Compatibility

open System
open System.Reflection


let argv = CompatArray.to_array (System.Environment.GetCommandLineArgs())
let file_exists  (s:string) = System.IO.File.Exists(s)
let remove (s:string) = System.IO.File.Delete(s)
let rename (s:string) (s2:string) = System.IO.File.Move(s,s2)

let getenv (s:string) =
  System.Environment.GetEnvironmentVariable(s) ?? not_found()

let command (s:string) = 
  let psi = new System.Diagnostics.ProcessStartInfo("cmd","/c "^s) in 
  psi.UseShellExecute <- false;
  psi.UseShellExecute <- false;
  let p = System.Diagnostics.Process.Start(psi) in
  p.WaitForExit();
  p.ExitCode


let chdir (s:string) = System.IO.Directory.SetCurrentDirectory(s)
let getcwd () = System.IO.Directory.GetCurrentDirectory()

let word_size = (# "sizeof !0" type(nativeint) : int #) * 8

// Like OCaml Sys.time only returns the process time from the main thread
// The documentation doesn't guarantee this is the main thread, 
// but it always appears to be.  There seems to be no way to grok
// the threads for the current process.  Note that refreshing the overall process
// time with Process.Refresh is very very slow.
let mainThread = 
  lazy 
    begin 
      let thisProcess = System.Diagnostics.Process.GetCurrentProcess() in 
      let threads = thisProcess.Threads in
      threads.[0]
    end
let time() = 
  try (Lazy.force mainThread).TotalProcessorTime.TotalSeconds
  with _ -> 
    // If the above failed, e.g. because main thread has exited, then do the following
    (System.Diagnostics.Process.GetCurrentProcess()).UserProcessorTime.TotalSeconds

let executable_name = 
 System.IO.Path.Combine(System.AppDomain.CurrentDomain.BaseDirectory,
                        System.AppDomain.CurrentDomain.FriendlyName)  
  
