// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Math

open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core
open Microsoft.FSharp.Math
open System

  

[<Obsolete("This type will be made private in a future release and thus should not be accessed directly")>]
type 'a opsData = INumeric<'a> option

/// <summary>
/// The type of matrices.  The arithmetic operations on the element type are determined by inspection on the element type itself
/// </summary>
type DenseMatrix<'a> = 
   {
        [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
        opsDM : 'a opsData;
        [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
#if CLI_AT_MOST_1_1
        arrDM : 'a array array
#else
        arrDM : 'a[,]
#endif
   } 

type SparseMatrix<'a> =
      { [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
        opsSM : 'a opsData;
        [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
        valsSM : 'a array;
        [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
        offsetsSM : int array; (* nrows + 1 elements *)
        [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
        ncolsSM : int;
        [<Obsolete("This member will be made private in a future release. If you have a need to access this representation directly please inform the F# team")>]
        colsSM : int array; } 

/// <summary>
/// The type of matrices.  The arithmetic operations on the element type are determined by inspection on the element type itself
/// </summary>
type Matrix<'a> = 
    | Dense of DenseMatrix<'a>
    | Sparse of SparseMatrix<'a>

    /// The number of rows in the matrix
    member NumRows : int
    /// The number of columns in the matrix
    member NumCols : int
    /// The number of (rows,columns) in the matrix
    member Dimensions : int * int
    /// Get the item at the given position in the matrix
    member Item : int * int -> 'a with get,set
    // v.[idx1..idx2,idx1..idx2] syntax
    member GetSlice2D      : start1:int option * finish1:int option * start2:int option * finish2:int option -> Matrix<'a>
    
    /// Retrieve the dictionary of numeric operations associated with the element
    /// type of this matrix.  Accessing the property may raise an NotSupportedException if the element
    /// type doesn't support any numeric operations.  The object returned
    /// may support additional numeric operations such as IFractional: 
    /// this can be determined by a dynamic type test against the object
    /// returned.
    member ElementOps : INumeric<'a>

    /// Point-wise addition of two matrices.  An InvalidArgument exception will be
    /// raised if the dimensions do not match.
    static member ( +  ) : Matrix<'a> * Matrix<'a> -> Matrix<'a>
    /// Point-wise subtraction of two matrices. An InvalidArgument exception will be
    /// raised if the dimensions do not match.
    static member ( -  ) : Matrix<'a> * Matrix<'a> -> Matrix<'a>
    /// Matrix negation.   
    static member ( ~- ) : Matrix<'a>              -> Matrix<'a>
    /// A nop.
    static member ( ~+ ) : Matrix<'a>              -> Matrix<'a>

    /// Matrix multiplication.   An InvalidArgument exception will be
    /// raised if the dimensions do not match.
    [<OverloadID("MultiplyMatrixMatrix")>]
    static member ( * ) : Matrix<'a> * Matrix<'a> -> Matrix<'a>

    /// Matrix-vector multiplication.   
    [<OverloadID("MultiplyMatrixVector")>]
    static member ( * ) : Matrix<'a> * Vector<'a> -> Vector<'a>

    /// Matrix-scalar multiplication.   
    [<OverloadID("MultiplyMatrixScalar")>]
    static member ( * ) : Matrix<'a> * 'a          -> Matrix<'a>

    /// Pointwise matrix multiplication.   An InvalidArgument exception will be
    /// raised if the dimensions do not match.
    static member ( .* ) : Matrix<'a> * Matrix<'a>  -> Matrix<'a>

    /// Multiply each element of a matrix by the given scalar value
    [<OverloadID("MultiplyScalarMatrix")>]
    static member ( * ) : 'a          * Matrix<'a> -> Matrix<'a>
    static member ( $* ) : 'a          * Matrix<'a> -> Matrix<'a>
    
    /// Multiply each element of a matrix by the given scalar value
    [<Obsolete("The * operator can now be used instead of this operator")>]
    static member ( *$ ) : Matrix<'a> * 'a          -> Matrix<'a>
    //static member ( ** ) : Matrix<'a> * float     -> Matrix<'a>

    // Inplace mutation operators.  
    /// Inplace matrix addition. An InvalidArgument exception will be
    /// raised if the dimensions do not match. 
    static member (  += ) : Matrix<'a> * Matrix<'a> -> unit
    /// Inplace matrix subtraction. An InvalidArgument exception will be
    /// raised if the dimensions do not match.
    static member (  -= ) : Matrix<'a> * Matrix<'a> -> unit
    /// Inplace pointwise matrix multiplication. An InvalidArgument exception will be
    /// raised if the dimensions do not match.
    static member ( .*= ) : Matrix<'a> * Matrix<'a> -> unit
    //static member ( *= ) : Matrix<'a> * Matrix<'a> -> unit

    /// Get the transpose of the matrix.
    member Transpose : Matrix<'a>
    
    /// Permutes the rows of the matrix.
    member PermuteRows : Permutation -> Matrix<'a>
    
    /// Permutes the columns of the matrix.
    member PermuteColumns : Permutation -> Matrix<'a>

#if CLI_AT_MOST_1_1
#else
    /// For native interop. Pin the given object for the duration of a single call to the given function.  A native pointer to
    /// the (0,0) element in the underlying array is passed to the given function.  Resources associated with the 
    /// pin are released when the function completes, even if an exception is raised.
    [<Unverifiable>]
    member inline Pin : ('a nativeptr -> 'b) -> 'b

    /// For native interop. Pin the given object, but the caller is responsible for freeing the GCHandle
    [<Unverifiable>]
    member inline PinHandle : unit -> 'a nativeptr * System.Runtime.InteropServices.GCHandle
#endif
        
    //interface IMatrix<'a>
    interface System.IComparable
    interface IStructuralHash
    interface Microsoft.FSharp.Text.StructuredFormat.IFormattable
    override GetHashCode : unit -> int
    override Equals : obj -> bool
  

/// <summary>
/// The type of column vectors.  The arithmetic operations on the element type are determined by inspection on the element type itself
/// </summary>
and Vector<'a> = 
    { [<Obsolete("This member will be made private in a future release and thus should not be accessed directly")>]
       opsV : 'a opsData;
       
       [<Obsolete("This member will be made private in a future release and thus should not be accessed directly")>]
       arrV : 'a array  } 

    // Basic access
    member Length : int
    member NumRows : int
    member Item : int -> 'a with get,set
    member ElementOps : INumeric<'a>
    
    // v.[idx1..idx2] syntax
    member GetSlice      : start:int option * finish:int option -> Vector<'a>

    // Basic operators
    static member ( +  ) : Vector<'a>    * Vector<'a> -> Vector<'a>
    static member ( -  ) : Vector<'a>    * Vector<'a> -> Vector<'a>
    static member ( ~- ) : Vector<'a>                  -> Vector<'a>
    static member ( ~+ ) : Vector<'a>                  -> Vector<'a>

    /// Pointwise multiplication of two vectors.
    static member ( .* ) : Vector<'a>    * Vector<'a> -> Vector<'a>

    /// Multiply each element of a vector by the given scalar value.
    [<OverloadID("ScalarVectorMultiply")>]
    static member ( * ) : 'a             * Vector<'a> -> Vector<'a>
    static member ( $* ) : 'a             * Vector<'a> -> Vector<'a>

    [<OverloadID("VectorRowVectorMultiply")>]
    static member ( * )   : Vector<'a>    * RowVector<'a> -> Matrix<'a>

    [<OverloadID("VectorScalarMultiply")>]
    static member ( * )   : Vector<'a>    * 'a          -> Vector<'a>

    [<Obsolete("The '*' operator can now be used instead of this operator")>]
    static member ( *$ )   : Vector<'a>    * 'a          -> Vector<'a>
    
    static member (  += ) : Vector<'a> * Vector<'a> -> unit
    static member (  -= ) : Vector<'a> * Vector<'a> -> unit
    static member ( .*= ) : Vector<'a> * Vector<'a> -> unit

    /// Get the transpose of the vector.
    member Transpose : RowVector<'a>
    
    /// Permute the elements of the vector.
    member Permute : Permutation -> Vector<'a>    

#if CLI_AT_MOST_1_1
#else
    /// For native interop. Pin the given object for the duration of a single call to the given function.  A native pointer to
    /// the (0,0) element in the underlying array is passed to the given function.  Resources associated with the 
    /// pin are released when the function completes, even if an exception is raised.
    [<Unverifiable>]
    member inline Pin : ('a nativeptr -> 'b) -> 'b

    /// For native interop. Pin the given object, but the caller is responsible for freeing the GCHandle
    [<Unverifiable>]
    member inline PinHandle : unit -> 'a nativeptr * System.Runtime.InteropServices.GCHandle
#endif
    
    //interface IVector<'a>
    interface System.IComparable
    interface IStructuralHash
    interface Microsoft.FSharp.Text.StructuredFormat.IFormattable
    override GetHashCode : unit -> int
    override Equals : obj -> bool

/// <summary>
/// The type of row vectors.  This type is included mostly only for completeness
/// and is used relatively rarely.
///</summary>
and RowVector<'a> =
    { [<Obsolete("This member will be made private in a future release and thus should not be accessed directly")>]
      opsRV : 'a opsData;
      [<Obsolete("This member will be made private in a future release and thus should not be accessed directly")>]
      arrRV : 'a array  } 

    // Basic access
    member Length : int
    member NumCols : int
    member Item : int -> 'a with get,set
    member ElementOps : INumeric<'a>

    // v.[idx1..idx2] syntax
    member GetSlice      : start:int option * finish:int option -> RowVector<'a>

    // Basic operators
    static member ( +  )  : RowVector<'a>    * RowVector<'a> -> RowVector<'a>
    static member ( -  )  : RowVector<'a>    * RowVector<'a> -> RowVector<'a>
    static member ( ~- )  : RowVector<'a>                  -> RowVector<'a>
    static member ( ~+ )  : RowVector<'a>                  -> RowVector<'a>

    static member ( .* )  : RowVector<'a> * RowVector<'a>    -> RowVector<'a>
    
    [<OverloadID("RowVectorVectorMultiply")>]
    static member ( * ) : RowVector<'a> * Vector<'a>    -> 'a

    [<OverloadID("RowVectorMatrixMultiply")>]
    static member ( * )   : RowVector<'a> * Matrix<'a>    -> RowVector<'a>

    [<OverloadID("RowVectorScalarMultiply")>]
    static member ( * )   : RowVector<'a> * 'a            -> RowVector<'a>

    [<OverloadID("ScalarRowVectorMultiply")>]
    static member ( * )  : 'a            * RowVector<'a>    -> RowVector<'a>
    static member ( $* )  : 'a            * RowVector<'a>    -> RowVector<'a>
    

    static member (  += ) : RowVector<'a> * RowVector<'a> -> unit
    static member (  -= ) : RowVector<'a> * RowVector<'a> -> unit
    static member ( .*= ) : RowVector<'a> * RowVector<'a> -> unit

    /// Get the transpose of the row vector.
    member Transpose : Vector<'a>
    
    /// Permute the elements of the row vector.
    member Permute : Permutation -> RowVector<'a>  

#if CLI_AT_MOST_1_1
#else
    /// For native interop. Pin the given object for the duration of a single call to the given function.  A native pointer to
    /// the (0,0) element in the underlying array is passed to the given function.  Resources associated with the 
    /// pin are released when the function completes, even if an exception is raised.
    [<Unverifiable>]
    member inline Pin : ('a nativeptr -> 'b) -> 'b

    /// Pin the given matrix, but the caller is responsible for freeing the GCHandle
    [<Unverifiable>]
    member inline PinHandle : unit -> 'a nativeptr * System.Runtime.InteropServices.GCHandle
#endif
    //interface IVector<'a>
    interface System.IComparable
    interface IStructuralHash
    interface Microsoft.FSharp.Text.StructuredFormat.IFormattable
    override GetHashCode : unit -> int
    override Equals : obj -> bool
  
/// The type of floating point matrices
type matrix = Matrix<float>
/// The type of floating point column vectors
type vector = Vector<float>
/// The type of floating point row vectors
type rowvec = RowVector<float>

/// Operations to manipulate floating
/// point matrices.  The submodule [[Matrix.Generic]] contains a 
/// matching set of operations to manipulate matrix types carrying
/// arbitrary element types.
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Matrix =

    /// Get an element of a matrix
    val get : matrix -> int -> int -> float

    /// Set an element of a matrix
    val set : matrix -> int -> int -> float -> unit

    /// Get the dimensions of a matrix (rows x columns)
    val dims : matrix -> int * int

    /// Get the number of rows of a matrix
    val nrows : matrix -> int

    /// Get the number of columns of a matrix
    val ncols : matrix -> int

    // Creation: general
    val init  : int -> int -> (int -> int -> float) -> matrix

    /// Create a matrix with all entries the given constant
    val create : int -> int -> float -> matrix
    
    /// Create a matrix with the given entries. 
#if CLI_AT_MOST_1_1
#else

    /// Create a dense representation matrix with the given entries. 
    val init_dense : int -> int -> #seq<int * int * float> -> matrix

    /// Create a sparse representation matrix with the given entries. Not all 
    /// operations are available for sparse matrices, and mutation is not permitted.
    /// If an operation on sparse matrices raises a runtime exception then consider 
    /// converting to a dense matrix using to_dense.
    val init_sparse : int -> int -> #seq<int * int * float> -> matrix
#endif
    // Create a sequence that iterates the non-zero entries in the martrix
    val nonzero_entries : matrix -> seq<int * int * float> 
        
    /// Create a matrix with all entries zero
    val zero     : int -> int          -> matrix
    
    /// Create a square matrix with the constant 1.0 lying on diagonal
    val identity      : int -> matrix

    /// Create a square matrix with the constant lying on diagonal
    val constDiag : int -> float      -> matrix

    /// Create a square matrix with the given vector lying on diagonal
    val diag      : vector            -> matrix
    
    val of_list   : float list list     -> matrix
    val of_seq    : #seq<#seq<float>>   -> matrix
#if CLI_AT_MOST_1_1
#else
    val of_array2 : float[,]            -> matrix
    val to_array2 :matrix                 -> float[,]
#endif
    val of_scalar  : float              -> matrix
    val of_rowvec  : rowvec             -> matrix
    val of_vector  : vector             -> matrix

    val to_scalar : matrix                -> float                
    val to_rowvec : matrix                -> rowvec                
    val to_vector : matrix                -> vector
    /// Ensure that a matrix uses dense representation.  See init_sparse
    val to_dense  : matrix                -> matrix

    ///Point-wise multiplication of two matrices (operator .*)
    val cptMul    : matrix -> matrix -> matrix
    
    ///Point-wise maximum element of two matrices
    val cptMax    : matrix -> matrix -> matrix
    
    ///Point-wise minimum element of two matrices
    val cptMin    : matrix -> matrix -> matrix
    
    ///Add two matrices (operator +)
    val add       : matrix -> matrix -> matrix

    ///Multiply two matrices (operator * )
    val mul       : matrix -> matrix -> matrix

    ///Multiply matrix by vector (operator *% )
    val mulV      : matrix -> vector -> vector

    ///Multiply row vector by matrix (operator *% )
    val mulRV     : rowvec -> matrix -> rowvec

    ///Subtract one matrix from another (operator -)
    val sub       : matrix -> matrix -> matrix

    ///Dot product
    val dot       : matrix -> matrix -> float

    ///Negation of the matrix (each element is negated) (unary operator -)
    val neg       :           matrix -> matrix

    ///Pointwise exponential of a matrix.
    val cptPow       : matrix -> float -> matrix

    ///Transpose of a matrix.  Use also m.Transpose
    val transpose     :           matrix -> matrix

    ///Pointwise multiplication of a matrix by a scalar
    val scale     : float  -> matrix -> matrix

    /// Sum of the diagonal elements of the matrix
    val trace     : matrix -> float
    
    ///Generate a new matrix of the same size as the input with random entries 
    ///drawn from the range 0..aij.  Random numbers are generated using a globally 
    ///shared System.Random instance with the initial seed 99.
    val randomize : matrix -> matrix

    /// Select a column from a matrix as a vector.
    val getCol  : matrix -> int -> vector

    /// Select a row from a matrix as a row vector.
    val getRow  : matrix -> int -> rowvec

    /// Select a number of columns from a matrix.  
    val getCols : matrix -> start:int -> length:int -> matrix

    /// Select a number of rows from a matrix. 
    val getRows : matrix -> start:int -> length:int -> matrix

    /// Select a region from a matrix.  
    val getRegion  : matrix -> starti:int -> startj:int -> lengthi:int -> lengthj:int -> matrix

    /// Return the nth diagonal of a matrix, as a vector.  Diagonal 0 is the primary
    /// diagonal, positive diagonals are further to the upper-right of the matrix.
    val getDiagN : matrix -> int    -> vector

    /// Return the primary diagonal of a matrix, as a vector.
    val getDiag  : matrix           -> vector

    ///Sum all the elements of a matrix
    val sum       : matrix -> float

    ///Multiply all the elements of the matrix
    val prod      : matrix -> float

    ///sqrt(sum(x*x)) of all the elements of a matrix
    val norm      : matrix -> float

    /// Check if a predicate holds for all elements of a matrix
    val forall  : (float -> bool) -> matrix -> bool
    /// Check if a predicate holds for at least one element of a matrix
    val exists  : (float -> bool) -> matrix -> bool 

    /// Check if a predicate holds for all elements of a matrix
    val foralli  : (int -> int -> float -> bool) -> matrix -> bool
    /// Check if a predicate holds for at least one element of a matrix
    val existsi  : (int -> int -> float -> bool) -> matrix -> bool 

    /// Fold the given function over all elements of a matrix
    val fold      : ('a -> float -> 'a) -> 'a         -> matrix -> 'a
    /// Fold the given function over all elements of a matrix
    val foldi      : (int -> int -> 'a -> float -> 'a) -> 'a         -> matrix -> 'a
    /// Fold the given function down each column of a matrix
    val foldByCol : ('a -> float -> 'a) -> RowVector<'a> -> matrix -> RowVector<'a>
    /// Fold the given function along each row of a matrix
    val foldByRow : ('a -> float -> 'a) -> Vector<'a> -> matrix -> Vector<'a>
    /// Fold the given function along a particular column of a matrix
    val foldCol   : ('a -> float -> 'a) -> 'a         -> matrix -> int -> 'a 
    /// Fold the given function down a particular row of a matrix
    val foldRow   : ('a -> float -> 'a) -> 'a         -> matrix -> int -> 'a
    
    /// Map the given function over each element of the matrix, producing a new matrix
    val map  : (float -> float) -> matrix -> matrix
   
    /// Map the given indexed function over each element of the matrix, producing a new matrix
    val mapi  : (int -> int -> float -> float) -> matrix -> matrix
   
    /// Create a new matrix that is a copy of the given array
    val copy : matrix -> matrix
   
    /// In-place assign mutates matrix argument. 
    val inplace_assign       : (int -> int -> float) -> matrix -> unit
    
    /// In-place map mutates matrix argument.
    val inplace_mapi  : (int -> int -> float -> float) -> matrix -> unit
    
    /// In-place addition mutates first matrix argument.
    val inplace_add    : matrix -> matrix -> unit

    /// In-place subtraction mutates first matrix argument. 
    val inplace_sub    : matrix -> matrix -> unit

    /// In-place componentwise-multiplication mutates first matrix argument. 
    val inplace_cptMul : matrix -> matrix -> unit

    /// In-place scaling mutates matrix argument.
    val inplace_scale  : float -> matrix -> unit

    #if CLI_AT_MOST_1_1
    #else
    /// Operations to manipulate matrix types carrying
    /// arbitrary element types.  The names and types of the operations match those
    /// in the containing module Math.Matrix.  
    ///
    /// The numeric operations on the element type (add, zero etc.) are inferred from the type
    /// argument itself. That is, for some operations 
    /// the element type of the matrix must have an associated instance of INumeric&lt;'a&gt; 
    /// or some more specific numeric association (see [[GlobalAssociations]]) ((else NotSupportedException)).
    module Generic =
        // Accessors

        /// Get an element from a matrix.  The indexes are given in row/column order.
        val get   : Matrix<'a> -> int -> int -> 'a
        /// Set an element in a matrix.  The indexes are given in row/column order.
        val set   : Matrix<'a> -> int -> int -> 'a -> unit
        /// Get the number of (rows,columns) in a matrix.  
        val dims   : Matrix<'a> -> int * int
        /// Get the number of rows in a matrix.  
        val nrows : Matrix<'a> -> int
        /// Get the number of columns in a matrix.  
        val ncols : Matrix<'a> -> int

        /// Get the dictionary of operations assocaited with the element type
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val eops : Matrix<'a> -> INumeric<'a>

        /// Create a matrix from the given (usually constant) data  
        val of_list      : 'a list list       -> Matrix<'a>
        val of_seq       : #seq<#seq<'a>>     -> Matrix<'a>

#if CLI_AT_MOST_1_1
#else
        /// Create a matrix from the given (usually constant) data  
        val of_array2    : 'a[,]              -> Matrix<'a>

        /// Return a new array containing the elements of the given matrix
        val to_array2 : Matrix<'a>         -> 'a[,]  
#endif

        /// Create a diagonal square matrix containing the given value along the diagonal.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val constDiag : int -> 'a          -> Matrix<'a>
        /// Create a matrix containing the given value at every element.
        val create     : int -> int -> 'a   -> Matrix<'a>

#if CLI_AT_MOST_1_1
#else
        val init_dense : int -> int -> #seq<int * int * 'a>  -> Matrix<'a>
        val init_sparse : int -> int -> #seq<int * int * 'a>  -> Matrix<'a>
#endif
        val nonzero_entries : Matrix<'a> -> seq<int * int * 'a> 

        /// Create a 1x1 matrix containing the given value 
        val of_scalar    : 'a                 -> Matrix<'a>

        val of_rowvec  : RowVector<'a>     -> Matrix<'a>
        val of_vector  : Vector<'a>        -> Matrix<'a>

        val to_scalar : Matrix<'a>         -> 'a                
        val to_rowvec : Matrix<'a>         -> RowVector<'a>                 
        val to_vector : Matrix<'a>         -> Vector<'a> 

        /// Create a matrix using the given function to compute the item at each index.
        val init : int -> int -> (int -> int -> 'a) -> Matrix<'a>

        /// Create a matrix using the given function to compute the item at each index.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        /// The function is passed the dictionary of associated operations in addition to the index pair.
        val init_numeric  : int -> int -> (INumeric<'a> -> int -> int -> 'a)        -> Matrix<'a>

        /// Create a matrix containing the zero element at each index.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val zero      : int -> int         -> Matrix<'a>

        /// Create a square matrix with the one for the element type lying on diagonal
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val identity      : int -> Matrix<'a>

        /// Create a matrix containing the given vector along the diagonal.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val diag      : Vector<'a>        -> Matrix<'a>

        /// Matrix addition.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val add       : Matrix<'a> -> Matrix<'a> -> Matrix<'a>

        /// Matrix multiplication.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val mul       : Matrix<'a> -> Matrix<'a> -> Matrix<'a>

        /// Matrix multiplication.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val mulV      : Matrix<'a> -> Vector<'a> -> Vector<'a>

        /// Matrix multiplication.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val mulRV     : RowVector<'a> -> Matrix<'a> -> RowVector<'a>

        /// Matrix pointwise-multiplication.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val cptMul    : Matrix<'a> -> Matrix<'a> -> Matrix<'a>

        ///Take the pointwise maximum of two matrices
        val cptMax    : Matrix<'a> -> Matrix<'a> -> Matrix<'a>

        ///Take the pointwise maximum of two matrices
        val cptMin    : Matrix<'a> -> Matrix<'a> -> Matrix<'a>

        /// Matrix subtraction.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val sub       : Matrix<'a> -> Matrix<'a> -> Matrix<'a>

        /// Sum of the point-wise multiple of the two matrices.
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val dot       : Matrix<'a> -> Matrix<'a> -> 'a
        val neg       : Matrix<'a> -> Matrix<'a>
        val transpose : Matrix<'a> -> Matrix<'a>
        val scale     : 'a  -> Matrix<'a> -> Matrix<'a>

        val trace     : Matrix<'a> -> 'a
        val sum       : Matrix<'a> -> 'a
        val prod      : Matrix<'a> -> 'a
        /// Returns sqrt(sum(norm(x)*(norm(x))) of all the elements of a matrix.
        /// The element type of the matrix must have an associated instance of INormFloat&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val norm      : Matrix<'a> -> float

        /// Select a column from a matrix
        val getCol  : Matrix<'a> -> int -> Vector<'a>
        /// Select a row from a matrix
        val getRow  : Matrix<'a> -> int -> RowVector<'a>
        /// Select a range of columns from a matrix
        val getCols : Matrix<'a> -> start:int -> length:int -> Matrix<'a>
        /// Select a range of rows from a matrix
        val getRows : Matrix<'a> -> start:int -> length:int -> Matrix<'a>
        /// Select a region from a matrix
        val getRegion  : Matrix<'a> -> starti:int -> startj:int -> lengthi:int -> lengthj:int -> Matrix<'a>

        ///Return the nth diagonal of a matrix as a vector
        /// The 0th index is the main diagonal, and higher indexes are further to the upper-right of the matrix.
        val getDiagN : Matrix<'a> -> int    -> Vector<'a>
        ///Return the diagonal of a matrix as a vector
        val getDiag  : Matrix<'a>           -> Vector<'a>

        // Second-order query operators
        val fold  : ('b -> 'a -> 'b) -> 'b -> Matrix<'a> -> 'b
        val foldi  : (int -> int -> 'b -> 'a -> 'b) -> 'b -> Matrix<'a> -> 'b
        val forall: ('a -> bool)           -> Matrix<'a> -> bool
        val exists: ('a -> bool)           -> Matrix<'a> -> bool 
        val foralli: (int -> int -> 'a -> bool)           -> Matrix<'a> -> bool
        val existsi: (int -> int -> 'a -> bool)           -> Matrix<'a> -> bool 

        /// Create a new matrix that is a copy of the given array
        val copy : Matrix<'a> -> Matrix<'a>
   
        // Second-order constructors
        val map   : ('a -> 'a) -> Matrix<'a> -> Matrix<'a>


        val mapi  : (int -> int -> 'a -> 'a) -> Matrix<'a> -> Matrix<'a>

        val compare  : Matrix<'a> -> Matrix<'a> -> int
        val hash     : Matrix<'a> -> int

        // In-place Mutation 
        val inplace_assign       : (int -> int -> 'a) -> Matrix<'a> -> unit
        val inplace_mapi  : (int -> int -> 'a -> 'a) -> Matrix<'a> -> unit

        val inplace_add    : Matrix<'a> -> Matrix<'a> -> unit
        val inplace_sub    : Matrix<'a> -> Matrix<'a> -> unit
        val inplace_cptMul : Matrix<'a> -> Matrix<'a> -> unit
        val inplace_scale  : 'a -> Matrix<'a> -> unit
    #endif
  

/// Operations to manipulate floating
/// point column vectors.  The submodule VectorOps.Generic contains a 
/// matching set of operations to manipulate column vectors carrying
/// arbitrary element types.
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Vector =

    /// Get an element of a column vector
    val get   : vector -> int -> float

    /// Set an element of a column vector
    val set   : vector -> int -> float -> unit

    /// Get the dimensions (number of rows) of a column vector.  Identical to [[nrows]]
    val length   : vector -> int 

    /// Get the number of rows of a column vector. 
    val nrows : vector -> int
    
    // Creation: general
    val init  : int ->        (int -> float)        -> vector

    /// Create a vector from a list of numbers
    val of_list   : float list          -> vector
    
    val of_seq    : #seq<float>         -> vector

    /// Create a vector from an array of double precision floats
    val of_array  : float array         -> vector

    /// Return a new array containing a copy of the elements of the given vector
    val to_array  : vector           -> float array
    
    /// Create a 1-element vector
    val of_scalar  : float              -> vector

    /// Generate a vector of the given length where each entry contains the given value
    val create    : int        -> float -> vector
    
    /// Return a vector of the given length where every entry is zero.
    val zero     : int                 -> vector
    
    /// Create a vector that represents a mesh over the given range
    /// e.g. rangef (-1.0) 0.5 1.0 = vector [ -1.0; -0.5; 0.0; 0.5; 1.0]
    val rangef : float -> float -> float -> vector
    
    /// Create a vector that represents a integral mesh over the given range
    /// e.g. range 1 5 = vector [ 1.;2.;3.;4.;5. ]
    val range  : int -> int              -> vector
      
    ///Point-wise multiplication of two vectors (operator .*)
    val cptMul    : vector -> vector -> vector
    
    ///Add two vectors (operator +)
    val add       : vector -> vector -> vector

    ///Subtract one vector from another (operator -)
    val sub       : vector -> vector -> vector

    ///Dot product
    val dot       : vector -> vector -> float

    ///Negation of the vector (each element is negated) (unary operator -)
    val neg       :           vector -> vector

    ///Pointwise exponential of a vector.
    val cptPow    : vector -> float -> vector

    ///Transpose of a matrix.  Use also m.Transpose
    val transpose     :           vector -> rowvec

    ///Pointwise multiplication of a matrix by a scalar
    val scale     : float  -> vector -> vector

    ///Sum all the elements of a vector
    val sum       : vector -> float

    ///Multiply all the elements of the matrix
    val prod      : vector -> float

    /// Computes the 2-norm of a vector: sqrt(x.Transpose*x).
    val norm      : vector -> float

    // Second-order query operators
    val forall  : (float -> bool) -> vector -> bool
    val exists  : (float -> bool) -> vector -> bool 
    val foralli  : (int ->        float -> bool) -> vector -> bool
    val existsi  : (int ->        float -> bool) -> vector -> bool 

    val fold      : ('a -> float -> 'a) -> 'a         -> vector -> 'a
    val foldi      : (int -> 'a -> float -> 'a) -> 'a         -> vector -> 'a

    val copy : vector -> vector
    
    // Second-order constructors
    val map  : (float -> float) -> vector -> vector
   
    // Second-order constructors
    val mapi  : (int        -> float -> float) -> vector -> vector
   
    // In-place Mutation 
    val inplace_assign       : (int ->        float) -> vector -> unit
    // In-place Mutation 
    val inplace_mapi  : (int ->        float -> float) -> vector -> unit
    // In-place Mutation 
    val inplace_add    : vector -> vector -> unit
    // In-place Mutation 
    val inplace_sub    : vector -> vector -> unit
    // In-place Mutation 
    val inplace_cptMul : vector -> vector -> unit
    // In-place Mutation 
    val inplace_scale  : float -> vector -> unit
    
    #if CLI_AT_MOST_1_1
    #else
    /// Operations to manipulate column vectors carrying
    /// arbitrary element types.  
    module Generic =
        // Accessors

        /// Get an element of a column vector
        val get   : Vector<'a> -> int -> 'a

        /// Set an element of a column vector
        val set   : Vector<'a> -> int -> 'a -> unit

        /// Get the dimensions (number of rows) of a column vector.  Identical to [[nrows]]
        val length   : Vector<'a> -> int 

        /// Get the number of rows of a column vector. 
        val nrows : Vector<'a> -> int
      
        /// Get the dictionary of operations assocaited with the element type
        /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) ((else NotSupportedException)).
        val eops : Vector<'a> -> INumeric<'a>
      
        /// Creation: general
        val init  : int ->        (int -> 'a)        -> Vector<'a>

        /// Creation: useful when the element type has associated operations.
        val init_numeric  : int ->        (INumeric<'a> -> int -> 'a)        -> Vector<'a>

        /// Create a vector from a list of numbers
        val of_list   : 'a list          -> Vector<'a>
      
        /// Create a vector from a sequence of numbers
        val of_seq    : #seq<'a>         -> Vector<'a>

        /// Create a 1-element vector
        val of_scalar  : 'a              -> Vector<'a>

        /// Create a vector from an array of elements
        val of_array  : 'a array         -> Vector<'a>

        /// Return a new array containing a copy of the elements of the given vector
        val to_array  : Vector<'a>    -> 'a array

        /// Generate a vector of the given length where each entry contains the given value
        val create    : int        -> 'a -> Vector<'a>
      
        /// Return a vector of the given length where every entry is zero.
        val zero     : int                 -> Vector<'a>
      
        ///Point-wise multiplication of two vectors (operator .*)
        val cptMul    : Vector<'a> -> Vector<'a> -> Vector<'a>
      
        ///Take the pointwise maximum of two vectors
        val cptMax    : Vector<'a> -> Vector<'a> -> Vector<'a>

        ///Take the pointwise minimum of two vectors
        val cptMin    : Vector<'a> -> Vector<'a> -> Vector<'a>

        ///Add two vectors (operator +)
        val add       : Vector<'a> -> Vector<'a> -> Vector<'a>

        ///Subtract one vector from another (operator -)
        val sub       : Vector<'a> -> Vector<'a> -> Vector<'a>

        ///Dot product
        val dot       : Vector<'a> -> Vector<'a> -> 'a

        ///Negation of the vector (each element is negated) (unary operator -)
        val neg       : Vector<'a> -> Vector<'a>

        ///Transpose of a matrix.  Use also m.Transpose
        val transpose : Vector<'a> -> RowVector<'a>

        ///Pointwise multiplication of a matrix by a scalar
        val scale     : 'a  -> Vector<'a> -> Vector<'a>

        ///Sum all the elements of a vector
        val sum       : Vector<'a> -> 'a
      
        ///Multiply all the elements of the matrix
        val prod      : Vector<'a> -> 'a

        /// Computes the 2-norm of a vector: sqrt(x.Transpose*x).
        val norm      : Vector<'a> -> float

        // Second-order query operators
        val forall  : ('a -> bool) -> Vector<'a> -> bool
        val exists  : ('a -> bool) -> Vector<'a> -> bool 
        val foralli  : (int -> 'a -> bool) -> Vector<'a> -> bool
        val existsi  : (int -> 'a -> bool) -> Vector<'a> -> bool 

        val fold      : ('b -> 'a -> 'b) -> 'b -> Vector<'a> -> 'b
        val foldi      : (int -> 'b -> 'a -> 'b) -> 'b -> Vector<'a> -> 'b
       
        val copy: Vector<'a> -> Vector<'a>
        
        // Second-order constructors
        val map  : ('a -> 'a) -> Vector<'a> -> Vector<'a>
     
        // Map the given function over each element.  The function is passed the
        // index of the element within the matrix
        val mapi  : (int        -> 'a -> 'a) -> Vector<'a> -> Vector<'a>
     
        // In-place Mutation 
        val inplace_assign       : (int ->        'a) -> Vector<'a> -> unit
        // In-place Mutation 
        val inplace_mapi  : (int ->        'a -> 'a) -> Vector<'a> -> unit
        // In-place Mutation 
        val inplace_add    : Vector<'a> -> Vector<'a> -> unit
        // In-place Mutation 
        val inplace_sub    : Vector<'a> -> Vector<'a> -> unit
        // In-place Mutation 
        val inplace_cptMul : Vector<'a> -> Vector<'a> -> unit
        // In-place Mutation 
        val inplace_scale  : 'a -> Vector<'a> -> unit
    
    #endif



/// Operations to manipulate floating
/// point row vectors.  These are included for completeness and are
/// nearly always transposed to column vectors.
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module RowVector =

    /// Get an element of a column vector
    val get   : rowvec -> int -> float

    /// Set an element of a column rowvec
    val set   : rowvec -> int -> float -> unit

    /// Get the dimensions (number of rows) of a column rowvec.  
    val length   : rowvec -> int 

      /// Create by constant initialization
    val create : int -> float  -> rowvec
      /// Create by comprehension
    val init : int ->  (int -> float) -> rowvec

    /// Return a vector of the given length where every entry is zero.
    val zero     : int -> rowvec

    // Transpose the row vector
    val transpose : rowvec -> vector

    // Copy the row vector
    val copy : rowvec -> rowvec

    /// Create a vector from a list of numbers
    val of_list   : float list          -> rowvec

    val of_seq    : #seq<float>         -> rowvec

    /// Create a vector from an array of double precision floats
    val of_array  : float array         -> rowvec

    /// Return a new array containing a copy of the elements of the given vector
    val to_array  : rowvec              -> float array
    
    
    #if CLI_AT_MOST_1_1
    #else
    /// Operations to manipulate row vectors types carrying
    /// arbitrary element types. 
    module Generic =
        // Accessors

        /// Get an element from a column vector.  
        val get   : RowVector<'a> -> int -> 'a
        /// Set an element in a column vector.  
        val set   : RowVector<'a> -> int -> 'a -> unit
        /// Get the number of rows in a column vector.  
        val length: RowVector<'a> -> int 
        /// Transpose the row vector
        val transpose        : RowVector<'a>  -> Vector<'a> 
        /// Create by comprehension
        val init       : int ->        (int -> 'a)        -> RowVector<'a> 
        /// Create by constant initialization
        val create       : int ->      'a  -> RowVector<'a> 
        /// Return a vector of the given length where every entry is zero.
        val zero     : int                 -> RowVector<'a>
        /// Create a row vector from a list of elements
        val of_list   : 'a list          -> RowVector<'a> 
        /// Create a row vector from a sequence of elements
        val of_seq    : #seq<'a>         -> RowVector<'a> 

        /// Create a row vector from an array of elements
        val of_array  : 'a array         -> RowVector<'a>

        /// Return a new array containing a copy of the elements of the given vector
        val to_array  : RowVector<'a>    -> 'a array         

  
        // Copy the row vector
        val copy    :   RowVector<'a> -> RowVector<'a>

    #endif
  
namespace Microsoft.FSharp.Core

    /// The type of floating-point matrices.  See Microsoft.FSharp.Math
    type matrix = Microsoft.FSharp.Math.matrix
    /// The type of floating-point vectors.  See Microsoft.FSharp.Math
    type vector = Microsoft.FSharp.Math.vector
    /// The type of floating-point row vectors.  See Microsoft.FSharp.Math
    type rowvec = Microsoft.FSharp.Math.rowvec

namespace Microsoft.FSharp.Math.Types

    type Matrix<'a> = Microsoft.FSharp.Math.Matrix<'a>
    type Vector<'a> = Microsoft.FSharp.Math.Vector<'a>
    type RowVector<'a> = Microsoft.FSharp.Math.RowVector<'a>

