// (c) Microsoft Corporation 2005-2007. 

/// FFT multiplication used by BigNat.
/// Implements polynomial multiplication provided
/// the coefficients of the result (and hence of the arguments too) fit inside Fp.
module Microsoft.FSharp.Math.Primitives.FFT 

    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Core

    /// fp is type for the finite field.
    /// Currently using p = 2^27.15+1 but do not rely on that.  
    /// Also, do not rely on fp being represented as uint32.
    type fp (* do not use rep type *) = uint32
    val mzero : fp
    val mone  : fp

    /// Maximum value in Fp is p-1.
    val max_fp             : fp
    val fp_of_int          : int -> fp
    val int_of_fp          : fp -> int

    /// "2^max_bits_inside_fp - 1" fits inside fp
    val max_bits_inside_fp : int

    val computeFftPaddedPolynomialProduct : int -> int -> fp array  -> fp array -> fp array 
    val computeFftPolynomialProduct        : int -> int array -> int -> int array -> int array 

