/* test-case.c generated by valac 0.27.1.3-6129, the Vala compiler
 * generated from test-case.vala, do not modify */

/* test-case.vala
 *
 * Copyright © 2011 Collabora Ltd.
 * Copyright © 2013 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *      Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *      Simon McVittie <simon.mcvittie@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <errno.h>


#define EDS_TEST_TYPE_TEST_CASE (eds_test_test_case_get_type ())
#define EDS_TEST_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCase))
#define EDS_TEST_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCaseClass))
#define EDS_TEST_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_TEST_CASE))
#define EDS_TEST_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_TEST_CASE))
#define EDS_TEST_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_TEST_CASE, EdsTestTestCaseClass))

typedef struct _EdsTestTestCase EdsTestTestCase;
typedef struct _EdsTestTestCaseClass EdsTestTestCaseClass;
typedef struct _EdsTestTestCasePrivate EdsTestTestCasePrivate;

#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EdsTestTestCase {
	FolksTestCase parent_instance;
	EdsTestTestCasePrivate * priv;
	EdsTestBackend* eds_backend;
};

struct _EdsTestTestCaseClass {
	FolksTestCaseClass parent_class;
	void (*create_backend) (EdsTestTestCase* self);
	void (*configure_primary_store) (EdsTestTestCase* self);
};


static gpointer eds_test_test_case_parent_class = NULL;

GType eds_test_test_case_get_type (void) G_GNUC_CONST;
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
enum  {
	EDS_TEST_TEST_CASE_DUMMY_PROPERTY
};
EdsTestTestCase* eds_test_test_case_new (const gchar* name);
EdsTestTestCase* eds_test_test_case_construct (GType object_type, const gchar* name);
static gchar* eds_test_test_case_real_create_transient_dir (FolksTestCase* base);
static void eds_test_test_case_real_private_bus_up (FolksTestCase* base);
static void eds_test_test_case_real_set_up (FolksTestCase* base);
void eds_test_test_case_create_backend (EdsTestTestCase* self);
void eds_test_test_case_configure_primary_store (EdsTestTestCase* self);
static void eds_test_test_case_real_create_backend (EdsTestTestCase* self);
EdsTestBackend* eds_test_backend_new (void);
EdsTestBackend* eds_test_backend_construct (GType object_type);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default, const gchar* name);
static void eds_test_test_case_real_configure_primary_store (EdsTestTestCase* self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_test_case_real_tear_down (FolksTestCase* base);
void eds_test_backend_tear_down (EdsTestBackend* self);
static void eds_test_test_case_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


EdsTestTestCase* eds_test_test_case_construct (GType object_type, const gchar* name) {
	EdsTestTestCase * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 49 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 51 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = name;
#line 51 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) folks_test_case_construct (object_type, _tmp0_);
#line 53 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_setenv ("FOLKS_BACKENDS_ALLOWED", "eds", TRUE);
#line 54 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", "eds:local://test", TRUE);
#line 49 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	return self;
#line 128 "test-case.c"
}


EdsTestTestCase* eds_test_test_case_new (const gchar* name) {
#line 49 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	return eds_test_test_case_construct (EDS_TEST_TYPE_TEST_CASE, name);
#line 135 "test-case.c"
}


static gchar* eds_test_test_case_real_create_transient_dir (FolksTestCase* base) {
	EdsTestTestCase * self;
	gchar* result = NULL;
	gchar* transient = NULL;
	gchar* _tmp0_ = NULL;
	gchar* config_dir = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 58 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 60 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->create_transient_dir (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 60 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	transient = _tmp0_;
#line 63 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = g_strdup_printf ("%s/.config/evolution/sources", transient);
#line 63 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	config_dir = _tmp1_;
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = g_mkdir_with_parents (config_dir, 0700);
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	if (_tmp2_ != 0) {
#line 161 "test-case.c"
		gint _tmp3_ = 0;
		const gchar* _tmp4_ = NULL;
#line 66 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp3_ = errno;
#line 66 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = g_strerror (_tmp3_);
#line 66 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		g_error ("test-case.vala:66: unable to create '%s': %s", config_dir, _tmp4_);
#line 170 "test-case.c"
	}
#line 69 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	result = transient;
#line 69 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (config_dir);
#line 69 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	return result;
#line 178 "test-case.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/opt/gnome3/build/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 201 "test-case.c"
}


static void eds_test_test_case_real_private_bus_up (FolksTestCase* base) {
	EdsTestTestCase * self;
	gint exit_status = 0;
	gchar* capture_stdout = NULL;
	gchar* libexec = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 101 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	static const gchar* sources_services[] = {"org.gnome.evolution.dataserver.Sources3", "org.gnome.evolution.dataserver.Sources2", "org.gnome.evolution.dataserver.Sources1"};
#line 107 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	static const gchar* address_book_services[] = {"org.gnome.evolution.dataserver.AddressBook8", "org.gnome.evolution.dataserver.AddressBook7", "org.gnome.evolution.dataserver.AddressBook6", "org.gnome.evolution.dataserver.AddressBook5"};
#line 216 "test-case.c"
	GError * _inner_error_ = NULL;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->private_bus_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 77 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	exit_status = -1;
#line 78 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	capture_stdout = NULL;
#line 226 "test-case.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp0_ = g_strdup ("pkg-config");
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp1_ = g_strdup ("--variable=libexecdir");
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp2_ = g_strdup ("libedata-book-1.2");
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp3_[0] = _tmp0_;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp3_[1] = _tmp1_;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp3_[2] = _tmp2_;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = _tmp3_;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp4__length1 = 3;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		g_spawn_sync (NULL, _tmp4_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp5_, NULL, &_tmp6_, &_inner_error_);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_g_free0 (capture_stdout);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		capture_stdout = _tmp5_;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		exit_status = _tmp6_;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "test-case.c"
			goto __catch7_g_error;
		}
#line 91 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp7_ = exit_status;
#line 91 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		g_spawn_check_exit_status (_tmp7_, &_inner_error_);
#line 91 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 276 "test-case.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp8_ = NULL;
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		e1 = _inner_error_;
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_inner_error_ = NULL;
#line 95 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp8_ = e1->message;
#line 95 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		g_error ("test-case.vala:95: Error getting libexecdir from pkg-config: %s", _tmp8_);
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_g_error_free0 (e1);
#line 295 "test-case.c"
	}
	__finally7:
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_g_free0 (capture_stdout);
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		g_clear_error (&_inner_error_);
#line 80 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		return;
#line 308 "test-case.c"
	}
#line 98 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp9_ = capture_stdout;
#line 98 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp10_ = string_strip (_tmp9_);
#line 98 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	libexec = _tmp10_;
#line 316 "test-case.c"
	{
		guint i = 0U;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		i = (guint) 0;
#line 321 "test-case.c"
		{
			gboolean _tmp11_ = FALSE;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
			_tmp11_ = TRUE;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
			while (TRUE) {
#line 328 "test-case.c"
				guint _tmp13_ = 0U;
				gchar* service_file_name = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				guint _tmp16_ = 0U;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* service_file = NULL;
				guint _tmp21_ = 0U;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				if (!_tmp11_) {
#line 345 "test-case.c"
					guint _tmp12_ = 0U;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp12_ = i;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					i = _tmp12_ + 1;
#line 351 "test-case.c"
				}
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp11_ = FALSE;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp13_ = i;
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				if (!(_tmp13_ < ((guint) G_N_ELEMENTS (sources_services)))) {
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					break;
#line 361 "test-case.c"
				}
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp14_ = folks_test_case_get_transient_dir ((FolksTestCase*) self);
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp15_ = _tmp14_;
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp16_ = i;
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp17_ = g_strdup_printf ("evolution-source-registry-%u.service", _tmp16_);
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp18_ = _tmp17_;
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp19_ = g_build_filename (_tmp15_, "dbus-1", "services", _tmp18_, NULL);
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp20_ = _tmp19_;
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (_tmp18_);
#line 118 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				service_file_name = _tmp20_;
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp21_ = i;
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp22_ = sources_services[_tmp21_];
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp23_ = libexec;
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp24_ = g_strdup_printf ("[D-BUS Service]\n" "Name=%s\n" "Exec=%s/evolution-source-registry\n", _tmp22_, _tmp23_);
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				service_file = _tmp24_;
#line 391 "test-case.c"
				{
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp25_ = service_file_name;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp26_ = service_file;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_file_set_contents (_tmp25_, _tmp26_, (gssize) (-1), &_inner_error_);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						if (_inner_error_->domain == G_FILE_ERROR) {
#line 405 "test-case.c"
							goto __catch8_g_file_error;
						}
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file_name);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (libexec);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (capture_stdout);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						g_clear_error (&_inner_error_);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						return;
#line 422 "test-case.c"
					}
				}
				goto __finally8;
				__catch8_g_file_error:
				{
					GError* e2 = NULL;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					e2 = _inner_error_;
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_inner_error_ = NULL;
#line 132 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp27_ = service_file_name;
#line 132 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp28_ = e2->message;
#line 132 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_error ("test-case.vala:132: Error creating D-Bus service file ‘%s’: %s", _tmp27_, _tmp28_);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_error_free0 (e2);
#line 443 "test-case.c"
				}
				__finally8:
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file_name);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (libexec);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (capture_stdout);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_clear_error (&_inner_error_);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					return;
#line 462 "test-case.c"
				}
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file);
#line 116 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file_name);
#line 468 "test-case.c"
			}
		}
	}
	{
		guint i = 0U;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		i = (guint) 0;
#line 476 "test-case.c"
		{
			gboolean _tmp29_ = FALSE;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
			_tmp29_ = TRUE;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
			while (TRUE) {
#line 483 "test-case.c"
				guint _tmp31_ = 0U;
				gchar* service_file_name = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				guint _tmp34_ = 0U;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* service_file = NULL;
				guint _tmp39_ = 0U;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				if (!_tmp29_) {
#line 500 "test-case.c"
					guint _tmp30_ = 0U;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp30_ = i;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					i = _tmp30_ + 1;
#line 506 "test-case.c"
				}
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp29_ = FALSE;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp31_ = i;
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				if (!(_tmp31_ < ((guint) G_N_ELEMENTS (address_book_services)))) {
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					break;
#line 516 "test-case.c"
				}
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp32_ = folks_test_case_get_transient_dir ((FolksTestCase*) self);
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp33_ = _tmp32_;
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp34_ = i;
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp35_ = g_strdup_printf ("evolution-addressbook-factory-%u.service", _tmp34_);
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp36_ = _tmp35_;
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp37_ = g_build_filename (_tmp33_, "dbus-1", "services", _tmp36_, NULL);
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp38_ = _tmp37_;
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (_tmp36_);
#line 140 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				service_file_name = _tmp38_;
#line 143 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp39_ = i;
#line 143 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp40_ = address_book_services[_tmp39_];
#line 143 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp41_ = libexec;
#line 143 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_tmp42_ = g_strdup_printf ("[D-BUS Service]\n" "Name=%s\n" "Exec=%s/evolution-addressbook-factory\n", _tmp40_, _tmp41_);
#line 143 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				service_file = _tmp42_;
#line 546 "test-case.c"
				{
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp43_ = service_file_name;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp44_ = service_file;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_file_set_contents (_tmp43_, _tmp44_, (gssize) (-1), &_inner_error_);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						if (_inner_error_->domain == G_FILE_ERROR) {
#line 560 "test-case.c"
							goto __catch9_g_file_error;
						}
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (service_file_name);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (libexec);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						_g_free0 (capture_stdout);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						g_clear_error (&_inner_error_);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
						return;
#line 577 "test-case.c"
					}
				}
				goto __finally9;
				__catch9_g_file_error:
				{
					GError* e3 = NULL;
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					e3 = _inner_error_;
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_inner_error_ = NULL;
#line 154 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp45_ = service_file_name;
#line 154 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_tmp46_ = e3->message;
#line 154 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_error ("test-case.vala:154: Error creating D-Bus service file ‘%s’: %s", _tmp45_, _tmp46_);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_error_free0 (e3);
#line 598 "test-case.c"
				}
				__finally9:
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (service_file_name);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (libexec);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					_g_free0 (capture_stdout);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					g_clear_error (&_inner_error_);
#line 148 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
					return;
#line 617 "test-case.c"
				}
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file);
#line 138 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
				_g_free0 (service_file_name);
#line 623 "test-case.c"
			}
		}
	}
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (libexec);
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (capture_stdout);
#line 631 "test-case.c"
}


static void eds_test_test_case_real_set_up (FolksTestCase* base) {
	EdsTestTestCase * self;
#line 160 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 162 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->set_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 163 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	eds_test_test_case_create_backend (self);
#line 164 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	eds_test_test_case_configure_primary_store (self);
#line 645 "test-case.c"
}


/**
   * Virtual method to create and set up the EDS backend.
   * Called from set_up(); may be overridden to not create the backend,
   * or to create it but not set it up.
   *
   * Subclasses may chain up, but are not required to so.
   */
static void eds_test_test_case_real_create_backend (EdsTestTestCase* self) {
	EdsTestBackend* _tmp0_ = NULL;
	EdsTestBackend* _tmp1_ = NULL;
#line 176 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = eds_test_backend_new ();
#line 176 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_eds_test_backend_unref0 (self->eds_backend);
#line 176 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self->eds_backend = _tmp0_;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = self->eds_backend;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	eds_test_backend_set_up (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDS_TEST_TYPE_BACKEND, EdsTestBackend), FALSE, "test");
#line 669 "test-case.c"
}


void eds_test_test_case_create_backend (EdsTestTestCase* self) {
#line 174 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_return_if_fail (self != NULL);
#line 174 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	EDS_TEST_TEST_CASE_GET_CLASS (self)->create_backend (self);
#line 678 "test-case.c"
}


/**
   * Virtual method to configure ``FOLKS_PRIMARY_STORE`` to point to
   * our //eds_backend//.
   *
   * Subclasses may chain up, but are not required to so.
   */
static void eds_test_test_case_real_configure_primary_store (EdsTestTestCase* self) {
	EdsTestBackend* _tmp0_ = NULL;
	gchar* config_val = NULL;
	EdsTestBackend* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 189 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = self->eds_backend;
#line 189 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_vala_assert (_tmp0_ != NULL, "this.eds_backend != null");
#line 190 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp1_ = self->eds_backend;
#line 190 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = eds_test_backend_get_address_book_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDS_TEST_TYPE_BACKEND, EdsTestBackend));
#line 190 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp3_ = _tmp2_;
#line 190 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp4_ = g_strconcat ("eds:", _tmp3_, NULL);
#line 190 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	config_val = _tmp4_;
#line 191 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", config_val, TRUE);
#line 186 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_g_free0 (config_val);
#line 713 "test-case.c"
}


void eds_test_test_case_configure_primary_store (EdsTestTestCase* self) {
#line 186 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_return_if_fail (self != NULL);
#line 186 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	EDS_TEST_TEST_CASE_GET_CLASS (self)->configure_primary_store (self);
#line 722 "test-case.c"
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 729 "test-case.c"
}


static void eds_test_test_case_real_tear_down (FolksTestCase* base) {
	EdsTestTestCase * self;
	EdsTestBackend* _tmp0_ = NULL;
	GMainContext* context = NULL;
	GMainContext* _tmp2_ = NULL;
	GMainContext* _tmp3_ = NULL;
#line 194 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self = (EdsTestTestCase*) base;
#line 196 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp0_ = self->eds_backend;
#line 196 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	if (_tmp0_ != NULL) {
#line 745 "test-case.c"
		EdsTestBackend* _tmp1_ = NULL;
#line 198 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp1_ = self->eds_backend;
#line 198 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		eds_test_backend_tear_down (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDS_TEST_TYPE_BACKEND, EdsTestBackend));
#line 199 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_eds_test_backend_unref0 (self->eds_backend);
#line 199 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		self->eds_backend = NULL;
#line 755 "test-case.c"
	}
#line 202 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	g_unsetenv ("FOLKS_PRIMARY_STORE");
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp2_ = g_main_context_default ();
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_tmp3_ = _g_main_context_ref0 (_tmp2_);
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	context = _tmp3_;
#line 211 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	while (TRUE) {
#line 767 "test-case.c"
		GMainContext* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 211 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp4_ = context;
#line 211 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		_tmp5_ = g_main_context_iteration (_tmp4_, FALSE);
#line 211 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
		if (!_tmp5_) {
#line 211 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
			break;
#line 778 "test-case.c"
		}
	}
#line 213 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	FOLKS_TEST_CASE_CLASS (eds_test_test_case_parent_class)->tear_down (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 194 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_g_main_context_unref0 (context);
#line 785 "test-case.c"
}


static void eds_test_test_case_class_init (EdsTestTestCaseClass * klass) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	eds_test_test_case_parent_class = g_type_class_peek_parent (klass);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->create_transient_dir = eds_test_test_case_real_create_transient_dir;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->private_bus_up = eds_test_test_case_real_private_bus_up;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->set_up = eds_test_test_case_real_set_up;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	((EdsTestTestCaseClass *) klass)->create_backend = eds_test_test_case_real_create_backend;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	((EdsTestTestCaseClass *) klass)->configure_primary_store = eds_test_test_case_real_configure_primary_store;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	((FolksTestCaseClass *) klass)->tear_down = eds_test_test_case_real_tear_down;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	G_OBJECT_CLASS (klass)->finalize = eds_test_test_case_finalize;
#line 806 "test-case.c"
}


static void eds_test_test_case_instance_init (EdsTestTestCase * self) {
#line 47 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self->eds_backend = NULL;
#line 813 "test-case.c"
}


static void eds_test_test_case_finalize (GObject* obj) {
	EdsTestTestCase * self;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_TEST_CASE, EdsTestTestCase);
#line 47 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	_eds_test_backend_unref0 (self->eds_backend);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/test-case.vala"
	G_OBJECT_CLASS (eds_test_test_case_parent_class)->finalize (obj);
#line 825 "test-case.c"
}


/**
 * A test case whose private D-Bus session contains the necessary daemons
 * for an Evolution address-book.
 *
 * The EDS daemons are started through D-Bus service activation in
 * {@link TestCase.private_bus_up}, and should automatically exit when the mock
 * D-Bus bus is torn down. All of their configuration and data storage is
 * isolated in a temporary directory which is unique per test run.
 *
 * The EDS daemons are only torn down in {@link TestCase.final_tear_down}, so
 * remain running between test cases in the same test binary. Their state is
 * soft-reset, but some state may be retained between test cases.
 */
GType eds_test_test_case_get_type (void) {
	static volatile gsize eds_test_test_case_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_test_case_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestTestCaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_test_case_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestTestCase), 0, (GInstanceInitFunc) eds_test_test_case_instance_init, NULL };
		GType eds_test_test_case_type_id;
		eds_test_test_case_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "EdsTestTestCase", &g_define_type_info, 0);
		g_once_init_leave (&eds_test_test_case_type_id__volatile, eds_test_test_case_type_id);
	}
	return eds_test_test_case_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



