/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;

public class SQLPlusWheneverSqlerrorParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private final Boolean suppressErrors;

    public SQLPlusWheneverSqlerrorParsedSqlStatement(int pos, int line, int col, String sql, List<Token> tokens) {
        super(pos, line, col, sql);
        tokens = this.filterTokens(tokens);
        if (tokens.size() < 3) {
            throw new FlywayException("Missing argument for WHENEVER SQLERROR");
        }
        String option = tokens.get(2).getText();
        if ("CONTINUE".equals(option)) {
            this.suppressErrors = true;
        } else if ("EXIT".equals(option) && tokens.size() > 3 && ("FAILURE".equals(tokens.get(3).getText()) || "SQL.SQLCODE".equals(tokens.get(3).getText()))) {
            this.suppressErrors = false;
        } else {
            throw new FlywayException("Unsupported option for WHENEVER SQLERROR: " + this.getSql());
        }
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        OracleResults oracleResults = new OracleResults();
        oracleResults.setSuppressErrors(this.suppressErrors);
        return oracleResults;
    }
}

