/***************************************************************************
 *   Free Heroes of Might and Magic II: https://github.com/ihhub/fheroes2  *
 *   Copyright (C) 2019 - 2022                                             *
 *                                                                         *
 *   Free Heroes2 Engine: http://sourceforge.net/projects/fheroes2         *
 *   Copyright (C) 2010 by Andrey Afletdinov <fheroes2@gmail.com>          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef H2AI_H
#define H2AI_H

#include "gamedefs.h"
#include "rand.h"

class StreamBase;
class Funds;
class Castle;
class HeroBase;
class Heroes;
class Kingdom;
class Army;
struct VecHeroes;
namespace Maps
{
    class Tiles;
}
namespace Battle
{
    class Arena;
    class Unit;
    class Actions;
}

namespace AI
{
    enum class AI_TYPE : int
    {
        NORMAL
    };
    enum AI_PERSONALITY
    {
        NONE,
        WARRIOR,
        BUILDER,
        EXPLORER
    };

    const double ARMY_ADVANTAGE_DESPERATE = 0.8;
    const double ARMY_ADVANTAGE_SMALL = 1.3;
    const double ARMY_ADVANTAGE_MEDIUM = 1.5;
    const double ARMY_ADVANTAGE_LARGE = 1.8;

    class Base
    {
    public:
        virtual void KingdomTurn( Kingdom & kingdom );
        virtual void CastleTurn( Castle & castle, bool defensive );
        virtual void BattleTurn( Battle::Arena & arena, const Battle::Unit & unit, Battle::Actions & actions );
        virtual void HeroTurn( Heroes & hero );
        virtual bool HeroesTurn( VecHeroes & )
        {
            return true;
        }

        virtual void revealFog( const Maps::Tiles & tile );

        virtual void HeroesAdd( const Heroes & hero );
        virtual void HeroesRemove( const Heroes & hero );
        virtual void HeroesPreBattle( HeroBase & hero, bool isAttacking );
        virtual void HeroesAfterBattle( HeroBase & hero, bool wasAttacking );
        virtual void HeroesPostLoad( Heroes & hero );
        virtual bool HeroesCanMove( const Heroes & hero );
        virtual bool HeroesGetTask( Heroes & hero );
        virtual void HeroesActionComplete( Heroes & hero );
        virtual void HeroesActionNewPosition( Heroes & hero );
        virtual void HeroesClearTask( const Heroes & hero );
        virtual void HeroesLevelUp( Heroes & hero );
        virtual std::string HeroesString( const Heroes & hero );

        virtual void CastleAdd( const Castle & castle );
        virtual void CastleRemove( const Castle & castle );
        virtual void CastlePreBattle( Castle & castle );
        virtual void CastleAfterBattle( Castle & castle, bool attackerWins );

        virtual const char * Type() const;
        virtual int GetPersonality() const; // To be utilized in future.
        virtual std::string GetPersonalityString() const;

        virtual void Reset();
        virtual void resetPathfinder() = 0;

        virtual ~Base() = default;

    protected:
        int _personality = NONE;

        Base() = default;

    private:
        friend StreamBase & operator<<( StreamBase &, const AI::Base & );
        friend StreamBase & operator>>( StreamBase &, AI::Base & );
    };

    Base & Get( AI_TYPE type = AI_TYPE::NORMAL );

    // functionality in ai_hero_action.cpp
    void HeroesAction( Heroes & hero, s32 dst_index );
    void HeroesMove( Heroes & hero );

    // functionality in ai_common.cpp
    bool BuildIfAvailable( Castle & castle, int building );
    bool BuildIfEnoughResources( Castle & castle, int building, uint32_t minimumMultiplicator );
    uint32_t GetResourceMultiplier( const Castle & castle, uint32_t min, uint32_t max );
    void ReinforceHeroInCastle( Heroes & hero, Castle & castle, const Funds & budget );
    void OptimizeTroopsOrder( Army & hero );

    StreamBase & operator<<( StreamBase &, const AI::Base & );
    StreamBase & operator>>( StreamBase &, AI::Base & );
}

#endif
