<!--
%% %CopyrightBegin%
%%
%% SPDX-License-Identifier: Apache-2.0
%%
%% Copyright Ericsson AB 2023-2025. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
-->
# Erlang/OTP System Documentation

The Erlang/OTP system documentation is a collection of guides describing how
to use Erlang/OTP and different aspects of working with Erlang/OTP. The guides are:

* [Installation Guide](installation_guide/installation_guide.md) -
  Describes how to build and install Erlang/OTP on Unix and Windows.
* [Getting Started With Erlang](getting_started/getting_started.md) -
  Describes how to get up and running with programming Erlang.
* [System Principles](system_principles/system_principles.md) -
  Describes how to build Erlang/OTP systems.
* [OTP Design Principles](design_principles/design_principles.md) -
  Describes how to build Erlang/OTP applications.
* [Programming Examples](programming_examples/programming_examples.md) -
  Examples on using records, funs, list comprehensions, and the bit syntax.
* [Erlang Reference Manual](reference_manual/reference_manual.md) -
  This section is the Erlang reference manual. It describes the Erlang programming language.
* [Efficiency Guide](efficiency_guide/efficiency_guide.md) -
  Describes how to write efficient code in Erlang-
* [Interoperability Tutorial](tutorial/tutorial.md) -
  This section informs on interoperability, that is, information exchange, between
  Erlang and other programming languages. The included examples mainly treat
  interoperability between Erlang and C.
* [Embedded Systems User's Guide](embedded/embedded.md) -
  This section describes the issues that are specific for running Erlang on an embedded system.
