/*
 * Code for class EW_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew176.h"
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <sys/wait.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F82_1017
static void inline_F82_1017 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F82_1017
#endif
#ifndef INLINE_F82_1020
static EIF_INTEGER_32 inline_F82_1020 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F82_1020
#endif
#ifndef INLINE_F82_1018
static EIF_POINTER inline_F82_1018 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F82_1018
#endif
#ifndef INLINE_F82_1016
static EIF_POINTER inline_F82_1016 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F82_1016
#endif
#ifndef INLINE_F82_1019
static void inline_F82_1019 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F82_1019
#endif
#ifndef INLINE_F82_1021
static void inline_F82_1021 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F82_1021
#endif
#ifndef INLINE_F82_1023
static EIF_INTEGER_32 inline_F82_1023 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F82_1023
#endif
#ifndef INLINE_F82_1022
static void inline_F82_1022 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F82_1022
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_OS}.null_file_name */

EIF_REFERENCE F211_2543 (EIF_REFERENCE Current)
{
	GTCX
	RTOSC (2543,RTMS32_EX_H("/\000\000\000d\000\000\000e\000\000\000v\000\000\000/\000\000\000n\000\000\000u\000\000\000l\000\000\000l\000\000\000",9,2028729708));
}

/* {EW_UNIX_OS}.executable_full_file_name */
EIF_REFERENCE F211_2544 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("executable_full_file_name", 210, Current, 0, 2, 2607);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F210_2537(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.full_directory_name */
EIF_REFERENCE F211_2545 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("full_directory_name", 210, Current, 0, 2, 2608);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F210_2537(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.new_pipe */
EIF_REFERENCE F211_2546 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("new_pipe", 210, Current, 2, 0, 2609);
	RTGC;
	RTHOOK(1);
	inline_F82_1017((EIF_INTEGER_32 *) &(loc1), (EIF_INTEGER_32 *) &(loc2));
	RTHOOK(2);
	tr1 = RTLNS(eif_new_type(912, 0x00).id, 912, _OBJSIZ_0_0_0_2_0_0_0_0_);
	F913_6287(RTCW(tr1), loc1, loc2);
	RTHOOK(3);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {EW_UNIX_OS}.fork_process */
EIF_INTEGER_32 F211_2547 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 210, Current, 0, 0, 2610);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F82_1020();
}

/* {EW_UNIX_OS}.exec_process */
void F211_2548 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_POINTER loc7 = (EIF_POINTER) 0;
	EIF_POINTER loc8 = (EIF_POINTER) 0;
	struct eif_ex_30 sloc9;
	EIF_REFERENCE loc9 = (EIF_REFERENCE) sloc9.data;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	memset (&sloc9.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc9.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc9.overhead, eif_new_type(50, 0x00).id);
	RTLI(7);
	RTLR(0,arg2);
	RTLR(1,loc4);
	RTLR(2,loc9);
	RTLR(3,arg1);
	RTLR(4,tr1);
	RTLR(5,loc5);
	RTLR(6,Current);
	RTLIU(7);
	
	RTEAA("exec_process", 210, Current, 9, 4, 2611);
	RTGC;
	RTHOOK(1);
	loc2 = F585_3357(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	RTHOOK(3);
	tr1 = F51_640(RTCW(loc9), arg1);
	loc4 = F895_5788(RTCW(tr1));
	RTHOOK(4);
	loc6 = inline_F82_1018((EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F585_3350(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		tr1 = F51_640(RTCW(loc9), tr1);
		loc5 = F895_5788(RTCW(tr1));
		RTHOOK(8);
		loc7 = inline_F82_1016(loc5);
		RTHOOK(9);
		inline_F82_1019(loc6, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc7);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F82_1019(loc6, loc2, loc8);
	RTHOOK(12);
	inline_F82_1021(loc4, loc6, arg3, arg4);
	RTHOOK(13);
	RTLE;
	RTEE;
}

/* {EW_UNIX_OS}.wait_for_process_block */
EIF_INTEGER_32 F211_2549 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_BOOLEAN loc1 = (EIF_BOOLEAN) 0;
	
	
	RTEAA("wait_for_process_block", 210, Current, 1, 1, 2612);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F82_1023(arg1, (EIF_BOOLEAN) 1, (EIF_BOOLEAN *) &(loc1));
}

/* {EW_UNIX_OS}.send_signal */
void F211_2551 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("send_signal", 210, Current, 0, 2, 2614);
	RTHOOK(1);
	inline_F82_1022(arg2, arg1);
	RTHOOK(2);
	RTEE;
}

/* {EW_UNIX_OS}.terminate_hard */
void F211_2552 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("terminate_hard", 210, Current, 0, 1, 2615);
	RTGC;
	RTHOOK(1);
	ti4_1 = RTOSCF(1036,F83_1036, (Current));
	F211_2551(Current, ti4_1, arg1);
	RTHOOK(2);
	RTLE;
	RTEE;
}

void EIF_Minit176 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
