/*
 * Code for class I18N_UNIX_C_FUNCTIONS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i197.h"
#include <eif_langinfo.h>
#include <iconv.h>
#include <locale.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F121_1688
static EIF_INTEGER_32 inline_F121_1688 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F121_1688
#endif
#ifndef INLINE_F121_1687
static EIF_POINTER inline_F121_1687 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F121_1687
#endif
#ifndef INLINE_F121_1682
static EIF_POINTER inline_F121_1682 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F121_1682
#endif
#ifndef INLINE_F121_1684
static EIF_POINTER inline_F121_1684 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F121_1684
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_UNIX_C_FUNCTIONS}.unix_set_locale */
void F121_1680 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(408, 0x00).id, 408, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F409_5075(RTCW(loc1), arg1);
	ti4_1 = inline_F121_1688();
	tp1 = F409_5097(RTCW(loc1));
	loc2 = inline_F121_1687(ti4_1, tp1);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		loc1 = RTLNS(eif_new_type(408, 0x00).id, 408, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F409_5079(RTCW(loc1), loc2);
		tr1 = RTOSCF(1686,F121_1686, (Current));
		tr2 = F409_5089(RTCW(loc1));
		F171_2262(RTCW(tr1), tr2);
	} else {
		tr1 = RTOSCF(1686,F121_1686, (Current));
		tr2 = RTMS_EX_H("POSIX",5,1331472728);
		F171_2262(RTCW(tr1), tr2);
	}
	RTLE;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info_managed */
EIF_REFERENCE F121_1681 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(335, 0x00).id, 335, _OBJSIZ_0_1_0_1_0_1_1_0_);
	tp1 = inline_F121_1682(arg1);
	F336_3804(RTCW(Result), tp1, ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info */
EIF_POINTER F121_1682 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	Result = inline_F121_1682 ((EIF_INTEGER_32) arg1);
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_is_available */
EIF_BOOLEAN F121_1683 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(408, 0x00).id, 408, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F409_5075(RTCW(loc1), arg1);
	ti4_1 = inline_F121_1688();
	tp1 = F409_5097(RTCW(loc1));
	tp1 = inline_F121_1687(ti4_1, tp1);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tp1 != loc2);
	tr1 = F121_1685(Current);
	F121_1680(Current, tr1);
	RTLE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_current_codeset */
EIF_POINTER F121_1684 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	Result = inline_F121_1684 ();
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name */
EIF_REFERENCE F121_1685 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	Result = *(EIF_REFERENCE *)(RTCV(RTOSCF(1686,F121_1686, (Current))));
	RTLE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name_cell */
static EIF_REFERENCE F121_1686_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	

	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTEV;
	RTGC;
	RTOSP (1686);
#define Result RTOSR(1686)
	RTOC_NEW(Result);
	{
		static EIF_TYPE_INDEX typarr0[] = {170,1051,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		tr1 = RTLNS(typres0.id, 170, _OBJSIZ_1_0_0_0_0_0_0_0_);
	}
	tr2 = RTMS_EX_H("POSIX",5,1331472728);
	F171_2262(RTCW(tr1), tr2);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (1686);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F121_1686 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(1686,F121_1686_body,(Current));
}

/* {I18N_UNIX_C_FUNCTIONS}.c_setlocale */
EIF_POINTER F121_1687 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	Result = inline_F121_1687 ((EIF_INTEGER_32) arg1, (EIF_POINTER) arg2);
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_lc_all */
EIF_INTEGER_32 F121_1688 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F121_1688 ();
	return Result;
}

void EIF_Minit97 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
