note
	description: 
		"Implementation of XVisibilityEvent."
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

class
	MEL_VISIBILITY_EVENT

inherit

	MEL_EVENT

create
	make

feature -- Access

	state: INTEGER
			-- Visibility state
		do
			Result := c_event_state (handle)
		ensure
			valid_result: is_visibility_unobscured or else
				is_visibility_partially_obscured or else
				is_visibility_full_obscured
		end;

	is_visibility_unobscured: BOOLEAN
			-- Is visibility unobscured?
		do
			Result := state = VisibilityUnobscured
		end;

	is_visibility_partially_obscured: BOOLEAN
			-- Is visibility partially obscured?
		do
			Result := state = VisibilityPartiallyObscured
		end;

	is_visibility_full_obscured: BOOLEAN
			-- Is visibility fully obscured?
		do
			Result := state = VisibilityFullyObscured
		end;

feature {NONE} -- Implementation

	c_event_state (event_ptr: POINTER): INTEGER
		external
			"C [macro %"events.h%"] (XVisibilityEvent *): EIF_INTEGER"
		end;

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class MEL_VISIBILITY_EVENT


