#include "sentence.hpp"
#include "simple_edge_label_feature_extractor.hpp"

namespace maeda {

namespace {
const std::string BOS("BOS");
const std::string EOS("EOS");
const std::string CONC("_");
} // namespace


std::string SimpleEdgeLabelFeatureExtractor::name() const {
  return "SimpleEdgeLabelFeatureExtractor";
}


void SimpleEdgeLabelFeatureExtractor::Extract(
    const Sentence &sentence,
    const int source,
    const int target,
    std::string *feature_string) const {

  const int length = int(sentence.rows.size());

  *feature_string += "1"
    + CONC + sentence.rows[source].form + CONC + sentence.rows[source].postag
    + CONC + sentence.rows[target].form + CONC + sentence.rows[target].postag;
  *feature_string += " ";

  // *feature_string += "2";
  // for (int k = std::min(source, target) + 1;
  //      k != std::max(source, target); k++) {
  //   *feature_string += CONC + sentence.rows[k].postag;
  // }
  // *feature_string += " ";

  *feature_string += "3"
    + CONC + sentence.rows[target].postag
    + CONC + (    1 <= target - 1 ? sentence.rows[target-1].postag : BOS)
    + CONC + (target + 1 < length ? sentence.rows[target+1].postag : EOS);
  *feature_string += " ";

  *feature_string += "4"
    + CONC + sentence.rows[source].postag
    + CONC + (    1 <= source - 1 ? sentence.rows[source-1].postag : BOS)
    + CONC + (source + 1 < length ? sentence.rows[source+1].postag : EOS);
}


} // maeda
