#ifndef SENTENCE_HPP_
#define SENTENCE_HPP_

#include <cstdlib>
#include <cstring>
#include <vector>
#include <iostream>
#include <algorithm>

namespace maeda {

const int kInvalidSentenceIndex = -1;

// ʸι
struct Row {
  std::string form;
  std::string lemma;
  std::string cpostag;
  std::string postag;
  std::string feats;
  int head;
  std::string deprel;
  std::string cluster;
  std::string netag;
  Row(const std::string &f, const std::string &l, const std::string &cp,
      const std::string &p, const std::string &ft, const int h,
      const std::string &d, const std::string &c, const std::string &n)
    : form(f), lemma(l), cpostag(cp), postag(p), feats(ft), head(h),
      deprel(d), cluster(c), netag(n) {}
};

struct Sentence {
  std::string id;
  std::vector<Row> rows;
  static const int kInvalidIndex = -1;
};


// Τ
// struct Sentence_ {
//   std::vector<int>         head;
//   std::vector<std::string> word;
//   std::vector<std::string> pos;
//   std::vector<std::string> cluster;

//   static const int kInvalidIndex = -1;
// };


typedef bool (*StreamReader)(std::istream &in, Sentence *sentence);
typedef void (*StreamWriter)(std::ostream &out, const Sentence &sentence);

bool ReadFromEdaDependencyStream(
    std::istream &in, Sentence *sentence);
void WriteToEdaDependencyStream(
    std::ostream &out, const Sentence &sentence);
bool ReadFromCoNLLDependencyStream(
    std::istream &in, Sentence *sentence);
void WriteToCoNLLDependencyStream(
    std::ostream &out, const Sentence &sentence);
bool ReadFromKyteaOutputStream(
    std::istream &in, Sentence *sentence);

bool GetExcludedIndicesByNE(
    const Sentence &sentence, std::vector<size_t> *indices);

} // maeda


#endif // SENTENCE_HPP_
