#ifndef UNLABELED_EDGE_FEATURE_EXTRACTOR_INTERFACE_HPP_
#define UNLABELED_EDGE_FEATURE_EXTRACTOR_INTERFACE_HPP_

#include <vector>
#include "sentence.hpp"


namespace maeda {

// ʸؿΤinterface
class UnlabeledEdgeFeatureExtractorInterface {
public:
  virtual ~UnlabeledEdgeFeatureExtractorInterface() {}

  virtual std::string name() const = 0;

  // ʸstd::vectorpush
  virtual void Extract(const Sentence &sentence,
                       const int source, const int target,
                       std::string *feature_string) const = 0;

protected:
  UnlabeledEdgeFeatureExtractorInterface() {};
};

} // maeda

#endif // UNLABELED_EDGE_FEATURE_EXTRACTOR_INTERFACE_HPP_
