#include <map>
#include <fstream>
#include "string_indexer.hpp"


namespace maeda {


FeatureID StringIndexer::Add(const std::string &str) {
  std::map<std::string, FeatureID>::iterator i = table_.find(str);
  if (i == table_.end()) {
    FeatureID id = FeatureID(table_.size());
    table_[str] = id;
    reverse_[id] = str;
    return id;
  } else {
    return i->second;
  }
}

FeatureID StringIndexer::GetID(const std::string &str) const {
  std::map<std::string, FeatureID>::const_iterator i = table_.find(str);
  return i == table_.end() ? kInvalidFeatureID : i->second;
}

std::string StringIndexer::GetStr(const FeatureID feature_id) const {
  std::map<FeatureID, std::string>::const_iterator i =
    reverse_.find(feature_id);
  return i == reverse_.end() ? "" : i->second;
}

void StringIndexer::Load(const std::string &filename) {
  std::string line;
  std::ifstream in(filename.c_str());
  while (std::getline(in, line)) {
    Add(line);
  }
}


} // maeda
