#include <sstream>
#include <iostream>
#include "sentence.hpp"

using namespace maeda;
using namespace std;

int main(void) {
  typedef std::vector<maeda::Sentence> SentenceList;

  SentenceList sentence_list;

  ifstream ifs("sample_test.tree");
  while (ifs) {
    Sentence sentence;
    if (ReadSentenceDependencies(ifs, &sentence) == false) {
      std::cerr << "error!" << std::endl;
      return 1;
    }
    sentence_list.push_back(sentence);
  }

  for (SentenceList::iterator i = sentence_list.begin();
       i != sentence_list.end(); i++) {
    for (int j = 0; j != int(i->word.size()); j++) {
      std::cerr << j << ":"
                << i->head[j] << " "
                << i->word[j] << " "
                << i->pos[j] << " "
                << i->cluster[j] << " "
                << std::endl;
    }
  }

  std::string str =
    "/̾/Ȥ礦 // /ư/ // /ư/";
  std::istringstream iss(str);
  Sentence sent;

  ReadKyteaOutputStream(iss, &sent);

  for (int j = 0; j != int(sent.word.size()); j++) {
    std::cerr << j << ":"
              << sent.head[j] << " "
              << sent.word[j] << " "
              << sent.pos[j]  << std::endl;
  }

  return 0;
}


