// Mathematical vector class

#ifndef _MATH_VEC_HPP_
#define _MATH_VEC_HPP_

#include <vector>
#include <iostream>
#include <cassert>

template <typename RealNumber = double>
class MathVec
{
private:
  std::vector<RealNumber> _v;
public:
  MathVec(const size_t n = 0, const RealNumber val = 0) { _v.resize(n, val); }
  MathVec(const std::vector<RealNumber> & v) : _v(v)    {}
  const std::vector<RealNumber> & STLVec() const { return _v; }
  std::vector<RealNumber>       & STLVec()       { return _v; }
  size_t Size() const { return _v.size(); }
  void resize(size_t n) { _v.resize(n); }
  RealNumber       & operator[](int i)       { return _v[i]; }
  const RealNumber & operator[](int i) const { return _v[i]; }
  MathVec & operator+=(const MathVec & b) {
    assert(b.Size() == _v.size());
    for (size_t i = 0; i < _v.size(); i++) {
      _v[i] += b[i];
    }
    return *this;
  }
  MathVec & operator*=(const RealNumber c) {
    for (size_t i = 0; i < _v.size(); i++) {
      _v[i] *= c;
    }
    return *this;
  }
  void Project(const MathVec & y) {
    for (size_t i = 0; i < _v.size(); i++) {
      //      if (sign(_v[i]) != sign(y[i])) _v[i] = 0;
      if (_v[i] * y[i] <=0) _v[i] = 0;
    }
  }
};

template <typename RealNumber> RealNumber dot_product(const MathVec<RealNumber> & a, const MathVec<RealNumber> & b)
{
  RealNumber sum = 0;
  for (size_t i = 0; i < a.Size(); i++) {
    sum += a[i] * b[i];
  }
  return sum;
}

template <typename RealNumber> std::ostream & operator<<(std::ostream & s, const MathVec<RealNumber> & a)
{
  s << "(";
  for (size_t i = 0; i < a.Size(); i++) {
    if (i != 0) s << ", ";
    s << a[i];
  }
  s << ")";
  return s;
}

template <typename RealNumber> const MathVec<RealNumber> operator+(const MathVec<RealNumber> & a, const MathVec<RealNumber> & b)
{
  MathVec<RealNumber> v(a.Size());
  assert(a.Size() == b.Size());
  for (size_t i = 0; i < a.Size(); i++) {
    v[i] = a[i] + b[i];
  }
  return v;
}

template <typename RealNumber> const MathVec<RealNumber> operator-(const MathVec<RealNumber> & a, const MathVec<RealNumber> & b)
{
  MathVec<RealNumber> v(a.Size());
  assert(a.Size() == b.Size());
  for (size_t i = 0; i < a.Size(); i++) {
    v[i] = a[i] - b[i];
  }
  return v;
}

template <typename RealNumber, typename Number2> const MathVec<RealNumber> operator*(const MathVec<RealNumber> & a, const Number2 c)
{
  MathVec<RealNumber> v(a.Size());
  for (size_t i = 0; i < a.Size(); i++) {
    v[i] = a[i] * c;
  }
  return v;
}

template <typename RealNumber, typename Number2> const MathVec<RealNumber> operator*(const Number2 c, const MathVec<RealNumber> & a)
{
  return a * c;
}



#endif
