/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import java.io.IOException;
import java.util.List;

public class FTPDeleteFeature
implements Delete {
    private final FTPSession session;

    public FTPDeleteFeature(FTPSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            callback.delete(file);
            try {
                if (file.isFile() || file.isSymbolicLink()) {
                    if (((FTPClient)((Object)this.session.getClient())).deleteFile(file.getAbsolute())) continue;
                    throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
                }
                if (!file.isDirectory()) continue;
                if (!((FTPClient)((Object)this.session.getClient())).changeWorkingDirectory(file.getParent().getAbsolute())) {
                    throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
                }
                if (((FTPClient)((Object)this.session.getClient())).removeDirectory(file.getAbsolute())) continue;
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
            catch (IOException e) {
                throw new FTPExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return false;
    }
}

