/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import com.microsoft.azure.storage.StorageException;
import java.net.UnknownHostException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureExceptionMappingService
extends AbstractExceptionMappingService<StorageException> {
    public BackgroundException map(StorageException e) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, e.getMessage());
        if (ExceptionUtils.getRootCause((Throwable)e) instanceof UnknownHostException) {
            return new NotfoundException(buffer.toString(), (Throwable)e);
        }
        switch (e.getHttpStatusCode()) {
            case 403: {
                return new LoginFailureException(buffer.toString(), (Throwable)e);
            }
            case 404: {
                return new NotfoundException(buffer.toString(), (Throwable)e);
            }
            case 304: 
            case 400: 
            case 405: 
            case 411: 
            case 412: {
                return new InteroperabilityException(buffer.toString(), (Throwable)e);
            }
            case 500: {
                return new ConnectionTimeoutException(buffer.toString(), (Throwable)e);
            }
            case 503: {
                return new RetriableAccessDeniedException(buffer.toString(), (Throwable)e);
            }
        }
        return this.wrap(e, buffer);
    }
}

