/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.util.NotThreadSafe;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

@NotThreadSafe
public class MultipartOutputStream
extends OutputStream {
    private OutputStream wrapped = null;
    private ByteArrayOutputStream backingBuffer;
    private int blockSize;

    private MultipartOutputStream() {
    }

    public MultipartOutputStream(int blockSize) {
        this.blockSize = blockSize;
        this.backingBuffer = new ByteArrayOutputStream(blockSize);
    }

    public MultipartOutputStream(int blockSize, ByteArrayOutputStream buf) {
        this.blockSize = blockSize;
        this.backingBuffer = buf;
    }

    public void setNext(OutputStream next) {
        this.wrapped = next;
    }

    public byte[] getRemainder() {
        return this.backingBuffer.toByteArray();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void write(byte[] bytesToWrite) throws IOException {
        int outstanding = this.backingBuffer.size() + bytesToWrite.length;
        if (outstanding < this.blockSize) {
            this.backingBuffer.write(bytesToWrite);
        } else {
            int remainder = outstanding % this.blockSize;
            this.flushBuffer();
            this.wrapped.write(bytesToWrite, 0, bytesToWrite.length - remainder);
            this.backingBuffer.write(bytesToWrite, bytesToWrite.length - remainder, remainder);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.backingBuffer.size() > 0) {
            this.wrapped.write(this.backingBuffer.toByteArray());
            this.backingBuffer.reset();
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.write(Arrays.copyOfRange(buffer, offset, offset + length));
    }

    @Override
    public void write(int value) throws IOException {
        this.wrapped.write(value);
    }

    public ByteArrayOutputStream getBuf() {
        return this.backingBuffer;
    }
}

