/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.jmx.JmxReporter;
import com.joyent.manta.config.MantaClientMetricConfiguration;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.Validate;
import org.slf4j.LoggerFactory;

final class MetricReporterSupplier
implements Supplier<Closeable> {
    public static final String FMT_METRIC_LOGGER_NAME = "com.joyent.manta.client.metrics";
    private final Closeable reporter;

    MetricReporterSupplier(MantaClientMetricConfiguration metricConfig) {
        Validate.notNull((Object)metricConfig);
        switch (metricConfig.getReporterMode()) {
            case JMX: {
                JmxReporter jmxReporter = MetricReporterSupplier.buildJmxReporter(metricConfig);
                jmxReporter.start();
                this.reporter = jmxReporter;
                break;
            }
            case SLF4J: {
                Slf4jReporter slf4jReporter = MetricReporterSupplier.buildSlf4jReporter(metricConfig);
                slf4jReporter.start((long)metricConfig.getPeriodicReporterOutputInterval().intValue(), TimeUnit.SECONDS);
                this.reporter = slf4jReporter;
                break;
            }
            default: {
                this.reporter = null;
            }
        }
    }

    @Override
    public Closeable get() {
        return this.reporter;
    }

    private static Slf4jReporter buildSlf4jReporter(MantaClientMetricConfiguration metricConfig) {
        return Slf4jReporter.forRegistry((MetricRegistry)metricConfig.getRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).prefixedWith(metricConfig.getClientId().toString()).outputTo(LoggerFactory.getLogger((String)FMT_METRIC_LOGGER_NAME)).build();
    }

    private static JmxReporter buildJmxReporter(MantaClientMetricConfiguration metricConfig) {
        return JmxReporter.forRegistry((MetricRegistry)metricConfig.getRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).createsObjectNamesWith((type, domain, name) -> {
            String metricJmxObjectName = String.format("com.joyent.manta.client:00=%s,type=%s", name, metricConfig.getClientId());
            try {
                return new ObjectName(metricJmxObjectName);
            }
            catch (MalformedObjectNameException e) {
                String msg = String.format("Unable to create JMX object name for metric: %s (name=%s, clientId=%s)", metricJmxObjectName, name, metricConfig.getClientId());
                throw new RuntimeException(msg, e);
            }
        }).build();
    }
}

