/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbstractAliasedQuery {
    protected final String queryString;
    protected final List<String> arguments;
    protected final int continuationValue;

    protected AbstractAliasedQuery(String queryString, List<String> arguments, int continuationValue) {
        if (queryString == null || queryString.isEmpty()) {
            throw new IllegalArgumentException("null or empty queryString");
        }
        if (continuationValue < 0) {
            throw new IllegalArgumentException("continuation value is less than zero");
        }
        if (arguments == null) {
            this.arguments = Collections.unmodifiableList(new ArrayList());
        } else {
            if (arguments.size() > 4) {
                throw new IllegalArgumentException("limit of 4 arguments");
            }
            this.arguments = Collections.unmodifiableList(arguments);
        }
        this.queryString = queryString;
        this.continuationValue = continuationValue;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("simpleQuery:");
        sb.append("\n   queryString:");
        sb.append(this.queryString);
        sb.append("\n   arguments:");
        sb.append(this.arguments);
        sb.append("\n  continuationValue:");
        sb.append(this.continuationValue);
        return sb.toString();
    }

    public int getContinuationValue() {
        return this.continuationValue;
    }

    public List<String> getArguments() {
        return this.arguments;
    }
}

