/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.domain;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.domain.IRODSDomainObject;

public final class AvuData
extends IRODSDomainObject {
    private String attribute = "";
    private String value = "";
    private String unit = "";

    public static AvuData instance(String attribute, String value, String unit) throws JargonException {
        return new AvuData(attribute, value, unit);
    }

    public AvuData() {
    }

    public AvuData(String attribute, String value, String unit) throws JargonException {
        if (attribute == null || attribute.isEmpty()) {
            throw new JargonException("attribute is null or empty");
        }
        if (value == null || value.isEmpty()) {
            throw new JargonException("value is null or empty");
        }
        if (unit == null) {
            throw new JargonException("unit is null, leave blank String if empty");
        }
        this.attribute = attribute;
        this.value = value;
        this.unit = unit;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("avu data:\n");
        sb.append("   attrib:");
        sb.append(this.attribute);
        sb.append("\n   value:");
        sb.append(this.value);
        sb.append("\n   units:");
        sb.append(this.unit);
        return sb.toString();
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AvuData)) {
            return false;
        }
        AvuData other = (AvuData)obj;
        return this.attribute.equals(other.attribute) && this.value.equals(other.value) && this.unit.equals(other.unit);
    }

    public int hashCode() {
        return this.attribute.hashCode() + this.value.hashCode() + this.unit.hashCode();
    }
}

