/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSThread;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;

public class SheetInvoker
extends ProxyController {
    private static final Logger log = Logger.getLogger(SheetInvoker.class);
    protected static final Set<SheetInvoker> registry = new HashSet<SheetInvoker>();
    private final SheetCallback callback;
    private final NSWindow parent;
    private NSWindow window;
    private final NSApplication application = NSApplication.sharedApplication();
    private final WindowController controller;
    private int returncode = -1;
    private final CountDownLatch signal = new CountDownLatch(1);

    public SheetInvoker(SheetCallback callback, WindowController parent, NSWindow sheet) {
        registry.add(this);
        this.callback = callback;
        this.parent = parent.window();
        this.window = sheet;
        this.controller = null;
    }

    public SheetInvoker(SheetCallback callback, WindowController parent, WindowController controller) {
        registry.add(this);
        this.callback = callback;
        this.parent = parent.window();
        this.controller = controller;
    }

    public SheetInvoker(SheetCallback callback, NSWindow parent, NSWindow sheet) {
        registry.add(this);
        this.callback = callback;
        this.parent = parent;
        this.window = sheet;
        this.controller = null;
    }

    public int getSelectedOption() {
        return this.returncode;
    }

    public int beginSheet() {
        if (NSThread.isMainThread()) {
            if (this.controller != null) {
                this.controller.loadBundle();
                return this.beginSheet(this.controller.window());
            }
            return this.beginSheet(this.window);
        }
        final SheetInvoker invoker = this;
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                if (SheetInvoker.this.controller != null) {
                    SheetInvoker.this.controller.loadBundle();
                    invoker.beginSheet(SheetInvoker.this.controller.window());
                } else {
                    invoker.beginSheet(SheetInvoker.this.window);
                }
            }
        }, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Await sheet dismiss");
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.signal);
        return this.returncode;
    }

    protected int beginSheet(NSWindow sheet) {
        this.parent.makeKeyAndOrderFront(null);
        this.application.beginSheet(sheet, this.parentWindow(), this.id(), Foundation.selector((String)"sheetDidClose:returnCode:contextInfo:"), null);
        return this.returncode;
    }

    public void sheetDidClose_returnCode_contextInfo(NSWindow sheet, int returncode, ID contextInfo) {
        sheet.endEditingFor(null);
        sheet.orderOut(contextInfo);
        this.returncode = returncode;
        this.callback.callback(returncode);
        this.signal.countDown();
    }

    private NSWindow parentWindow() {
        NSWindow window = this.parent;
        while (window.attachedSheet() != null) {
            window = window.attachedSheet();
            log.warn((Object)String.format("Window %s has already sheet %s attached", new Object[]{this.parent, window}));
        }
        return window;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        registry.remove((Object)this);
    }
}

