/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.BucketType;
import synapticloop.b2.LifecycleRule;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.BaseB2Response;

public class B2BucketResponse
extends BaseB2Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2BucketResponse.class);
    private final String bucketId;
    private final String accountId;
    private final String bucketName;
    private final String bucketType;
    private final Long revision;
    private final Map<String, String> bucketInfo;
    private final List<LifecycleRule> lifecycleRules = new ArrayList<LifecycleRule>();

    public B2BucketResponse(String json) throws B2ApiException {
        super(json);
        this.bucketId = this.readString("bucketId");
        this.accountId = this.readString("accountId");
        this.bucketName = this.readString("bucketName");
        this.bucketType = this.readString("bucketType");
        this.revision = this.readLong("revision");
        this.bucketInfo = this.readMap("bucketInfo");
        JSONArray lifecycleObjects = this.readObjects("lifecycleRules");
        for (Object object : lifecycleObjects) {
            this.lifecycleRules.add(new LifecycleRule((JSONObject)object));
        }
        this.warnOnMissedKeys();
    }

    public B2BucketResponse(JSONObject response) throws B2ApiException {
        super(response);
        this.bucketId = this.readString("bucketId");
        this.accountId = this.readString("accountId");
        this.bucketName = this.readString("bucketName");
        this.bucketType = this.readString("bucketType");
        this.revision = this.readLong("revision");
        this.bucketInfo = this.readMap("bucketInfo");
        JSONArray lifecycleObjects = this.readObjects("lifecycleRules");
        for (Object object : lifecycleObjects) {
            this.lifecycleRules.add(new LifecycleRule((JSONObject)object));
        }
        this.warnOnMissedKeys();
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public BucketType getBucketType() {
        try {
            return BucketType.valueOf(this.bucketType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Map<String, String> getBucketInfo() {
        return this.bucketInfo;
    }

    public long getRevision() {
        return this.revision;
    }

    public List<LifecycleRule> getLifecycleRules() {
        return this.lifecycleRules;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("B2BucketResponse{");
        sb.append("bucketId='").append(this.bucketId).append('\'');
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", bucketName='").append(this.bucketName).append('\'');
        sb.append(", bucketType='").append(this.bucketType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

