/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.BaseB2Request;
import synapticloop.b2.response.B2AuthorizeAccountResponse;

public class B2AuthorizeAccountRequest
extends BaseB2Request {
    private static final String B2_AUTHORIZE_ACCOUNT = "https://api.backblazeb2.com/b2api/v1/b2_authorize_account";

    public B2AuthorizeAccountRequest(CloseableHttpClient client, String accountId, String applicationKey) {
        super(client, B2_AUTHORIZE_ACCOUNT);
        this.addHeader("Authorization", String.format("Basic %s", Base64.encodeBase64String((byte[])String.format("%s:%s", accountId, applicationKey).getBytes())));
    }

    public B2AuthorizeAccountResponse getResponse() throws B2ApiException, IOException {
        CloseableHttpResponse httpResponse = this.executeGet();
        return new B2AuthorizeAccountResponse(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
    }
}

