/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.sftp.SFTPAttributesFinderFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.shared.DefaultUnixPermissionFeature;
import java.io.IOException;
import net.schmizz.sshj.sftp.FileAttributes;

public class SFTPUnixPermissionFeature
extends DefaultUnixPermissionFeature
implements UnixPermission {
    private final SFTPSession session;

    public SFTPUnixPermissionFeature(SFTPSession session) {
        this.session = session;
    }

    public void setUnixOwner(Path file, String owner) throws BackgroundException {
        FileAttributes attr = new FileAttributes.Builder().withUIDGID(new Integer(owner).intValue(), 0).build();
        try {
            this.session.sftp().setAttributes(file.getAbsolute(), attr);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public void setUnixGroup(Path file, String group) throws BackgroundException {
        FileAttributes attr = new FileAttributes.Builder().withUIDGID(0, new Integer(group).intValue()).build();
        try {
            this.session.sftp().setAttributes(file.getAbsolute(), attr);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public Permission getUnixPermission(Path file) throws BackgroundException {
        return new SFTPAttributesFinderFeature(this.session).find(file).getPermission();
    }

    public void setUnixPermission(Path file, Permission permission) throws BackgroundException {
        FileAttributes attr = new FileAttributes.Builder().withPermissions(Integer.parseInt(permission.getMode(), 8)).build();
        try {
            this.session.sftp().setAttributes(file.getAbsolute(), attr);
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

