/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.sftp.SFTPCommandFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPHomeDirectoryService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.IOException;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFTPQuotaFeature
implements Quota {
    private static final int MIN_SFTP_SPACE_AVAILABLE_VERSION = 6;
    private static final Logger log = Logger.getLogger(SFTPQuotaFeature.class);
    private final SFTPSession session;

    public SFTPQuotaFeature(SFTPSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        Path home = new SFTPHomeDirectoryService(this.session).find();
        if (this.isSpaceAvailableExtensionAvailable()) {
            try {
                return this.getSpaceAvailable(this.session.sftp(), home);
            }
            catch (BackgroundException e) {
                log.info((Object)String.format("Failure obtaining disk quota. %s.", e.getDetail()));
            }
        }
        if (this.isStatVFSOpenSSHSupported()) {
            try {
                return this.getSpaceStatVFSOpenSSH(this.session.sftp(), home);
            }
            catch (BackgroundException e) {
                log.info((Object)String.format("Failure obtaining disk quota. %s.", e.getDetail()));
            }
        }
        try {
            return this.getSpaceShellPrompt(home);
        }
        catch (BackgroundException e) {
            log.info((Object)String.format("Failure obtaining disk quota. %s.", e.getDetail()));
            return new Quota.Space(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE));
        }
    }

    private boolean isSpaceAvailableExtensionAvailable() {
        try {
            return this.session.sftp().getOperativeProtocolVersion() >= 6;
        }
        catch (BackgroundException e) {
            return false;
        }
    }

    private Quota.Space getSpaceAvailable(SFTPEngine sftp, Path directory) throws BackgroundException {
        try {
            Request request = (Request)sftp.newExtendedRequest("space-available").putString(directory.getAbsolute());
            Response response = (Response)sftp.request(request).retrieve();
            switch (response.getType()) {
                case EXTENDED_REPLY: {
                    long bytesOnDevice = response.readUInt64();
                    long unusedBytesOnDevice = response.readUInt64();
                    long bytesAvailableToUser = response.readUInt64();
                    long unusedBytesAvailableToUser = response.readUInt64();
                    int bytesPerAllocationUnit = response.readUInt32AsInt();
                    if (bytesAvailableToUser == 0L) {
                        if (bytesOnDevice == 0L) {
                            throw new IOException("SFTPv6 space-available did not return valid values.");
                        }
                        long available = unusedBytesOnDevice;
                        long used = bytesOnDevice - unusedBytesOnDevice;
                        return new Quota.Space(Long.valueOf(used), Long.valueOf(available));
                    }
                    long available = unusedBytesAvailableToUser;
                    long used = bytesAvailableToUser - unusedBytesAvailableToUser;
                    return new Quota.Space(Long.valueOf(used), Long.valueOf(available));
                }
            }
            throw new IOException(String.format("Unexpected response type %s", response.getType()));
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to read attributes of {0}", e, directory);
        }
    }

    private boolean isStatVFSOpenSSHSupported() {
        try {
            return this.session.sftp().supportsServerExtension("statvfs", "openssh.com");
        }
        catch (BackgroundException e) {
            return false;
        }
    }

    private Quota.Space getSpaceStatVFSOpenSSH(SFTPEngine sftp, Path directory) throws BackgroundException {
        try {
            Request request = (Request)sftp.newExtendedRequest("statvfs@openssh.com").putString(directory.getAbsolute());
            Response response = (Response)sftp.request(request).retrieve();
            switch (response.getType()) {
                case EXTENDED_REPLY: {
                    long blockSize = response.readUInt64();
                    long filesystemBlockSize = response.readUInt64();
                    long totalBlocks = response.readUInt64();
                    long filesystemFreeBlocks = response.readUInt64();
                    long blocksAvailable = response.readUInt64();
                    long fileInodes = response.readUInt64();
                    long fileInodesFree = response.readUInt64();
                    long fileInodesAvailable = response.readUInt64();
                    byte[] filesystemID = new byte[8];
                    response.readRawBytes(filesystemID);
                    long flags = response.readUInt64();
                    long maximumFilenameLength = response.readUInt64();
                    long total = totalBlocks * filesystemBlockSize;
                    long available = blocksAvailable * filesystemBlockSize;
                    long used = total - available;
                    return new Quota.Space(Long.valueOf(used), Long.valueOf(available));
                }
            }
            throw new IOException(String.format("Unexpected response type %s", response.getType()));
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Failure to read attributes of {0}", e, directory);
        }
    }

    private Quota.Space getSpaceShellPrompt(Path directory) throws BackgroundException {
        final ThreadLocal quota = new ThreadLocal();
        new SFTPCommandFeature(this.session).send(String.format("df -Pk %s | awk '{print $3, $4}'", directory.getAbsolute()), (ProgressListener)new DisabledProgressListener(), new TranscriptListener(){

            public void log(TranscriptListener.Type request, String output) {
                switch (request) {
                    case response: {
                        String[] numbers = StringUtils.split((String)output, (char)' ');
                        if (numbers.length == 2) {
                            try {
                                Long used = Long.valueOf(numbers[0]) * 1000L;
                                Long available = Long.valueOf(numbers[1]) * 1000L;
                                quota.set(new Quota.Space(used, available));
                            }
                            catch (NumberFormatException e) {
                                log.warn((Object)String.format("Ignore line %s", output));
                            }
                            break;
                        }
                        log.warn((Object)String.format("Ignore line %s", output));
                    }
                }
            }
        });
        if (null == quota.get()) {
            throw new SFTPExceptionMappingService().map("Failure to read attributes of {0}", new IOException(), directory);
        }
        return (Quota.Space)quota.get();
    }
}

