/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.analytics.QloudstatAnalyticsProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.DistributionUrlProvider;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.cdn.features.Purge;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.identity.DefaultCredentialsIdentityConfiguration;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.openstack.SwiftDistributionPurgeFeature;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.exception.NotFoundException;
import ch.iterate.openstack.swift.model.CDNContainer;
import ch.iterate.openstack.swift.model.ContainerMetadata;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftDistributionConfiguration
implements DistributionConfiguration,
Index,
DistributionLogging {
    private static final Logger log = Logger.getLogger(SwiftDistributionConfiguration.class);
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final Map<Path, Distribution> distributions;
    private final SwiftRegionService regionService;

    public SwiftDistributionConfiguration(SwiftSession session, Map<Path, Distribution> distributions) {
        this(session, distributions, new SwiftRegionService(session));
    }

    public SwiftDistributionConfiguration(SwiftSession session, Map<Path, Distribution> distributions, SwiftRegionService regionService) {
        this.session = session;
        this.distributions = distributions;
        this.regionService = regionService;
    }

    public void write(Path file, Distribution configuration, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            if (StringUtils.isNotBlank((CharSequence)configuration.getIndexDocument())) {
                ((Client)this.session.getClient()).updateContainerMetadata(this.regionService.lookup(container), container.getName(), Collections.singletonMap("X-Container-Meta-Web-Index", configuration.getIndexDocument()));
            }
            try {
                CDNContainer info = ((Client)this.session.getClient()).getCDNContainerInfo(this.regionService.lookup(container), container.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found existing CDN configuration %s", info));
                }
            }
            catch (NotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Enable CDN configuration for %s", container));
                }
                ((Client)this.session.getClient()).cdnEnableContainer(this.regionService.lookup(container), container.getName());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Update CDN configuration for %s", container));
            }
            ((Client)this.session.getClient()).cdnUpdateContainer(this.regionService.lookup(container), container.getName(), -1, configuration.isEnabled(), configuration.isLogging());
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Cannot write CDN configuration", e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot write CDN configuration", (Throwable)e);
        }
    }

    public Distribution read(Path file, Distribution.Method method, LoginCallback prompt) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            try {
                CDNContainer info = ((Client)this.session.getClient()).getCDNContainerInfo(this.regionService.lookup(container), container.getName());
                Distribution distribution = new Distribution(this.regionService.lookup(container).getStorageUrl(container.getName()), method, info.isEnabled());
                distribution.setId(info.getName());
                distribution.setStatus(info.isEnabled() ? LocaleFactory.localizedString((String)"CDN Enabled", (String)"Mosso") : LocaleFactory.localizedString((String)"CDN Disabled", (String)"Mosso"));
                if (StringUtils.isNotBlank((CharSequence)info.getCdnURL())) {
                    distribution.setUrl(URI.create(info.getCdnURL()));
                }
                if (StringUtils.isNotBlank((CharSequence)info.getSslURL())) {
                    distribution.setSslUrl(URI.create(info.getSslURL()));
                }
                if (StringUtils.isNotBlank((CharSequence)info.getStreamingURL())) {
                    distribution.setStreamingUrl(URI.create(info.getStreamingURL()));
                }
                if (StringUtils.isNotBlank((CharSequence)info.getiOSStreamingURL())) {
                    distribution.setiOSstreamingUrl(URI.create(info.getiOSStreamingURL()));
                }
                distribution.setLogging(info.getRetainLogs());
                distribution.setLoggingContainer(".CDN_ACCESS_LOGS");
                ContainerMetadata metadata = ((Client)this.session.getClient()).getContainerMetaData(this.regionService.lookup(container), container.getName());
                if (metadata.getMetaData().containsKey("X-Container-Meta-Web-Index")) {
                    distribution.setIndexDocument((String)metadata.getMetaData().get("X-Container-Meta-Web-Index"));
                }
                distribution.setContainers(Collections.singletonList(new Path("/.CDN_ACCESS_LOGS", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory))));
                return distribution;
            }
            catch (NotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("No CDN configuration for %s", container));
                }
                Distribution distribution = new Distribution(this.regionService.lookup(container).getStorageUrl(container.getName()), method, false);
                distribution.setStatus(LocaleFactory.localizedString((String)"CDN Disabled", (String)"Mosso"));
                return distribution;
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Cannot read CDN configuration", e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot read CDN configuration", (Throwable)e);
        }
    }

    public <T> T getFeature(Class<T> type, Distribution.Method method) {
        if (type == Purge.class) {
            return (T)new SwiftDistributionPurgeFeature(this.session, this.regionService);
        }
        if (type == Index.class) {
            return (T)this;
        }
        if (type == DistributionLogging.class) {
            return (T)this;
        }
        if (type == IdentityConfiguration.class) {
            return (T)new DefaultCredentialsIdentityConfiguration(this.session.getHost());
        }
        if (type == AnalyticsProvider.class) {
            return (T)new QloudstatAnalyticsProvider();
        }
        return null;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        Path container = this.containerService.getContainer(file);
        if (this.distributions.containsKey(container)) {
            return new DistributionUrlProvider(this.distributions.get(container)).toUrl(file);
        }
        return DescriptiveUrlBag.empty();
    }

    public String getHostname() {
        return this.session.getHost().getProtocol().getDefaultHostname();
    }

    public List<Distribution.Method> getMethods(Path container) {
        return Collections.singletonList(Distribution.DOWNLOAD);
    }

    public String getName() {
        return LocaleFactory.localizedString((String)"Akamai", (String)"Mosso");
    }

    public String getName(Distribution.Method method) {
        return this.getName();
    }
}

