/*
 * Decompiled with CFR 0.152.
 */
package io.milton.principal;

import java.util.List;

public class PrincipalSearchCriteria {
    public static final String CU_TYPE_INDIVIDUAL = "INDIVIDUAL";
    public static final String CU_TYPE_GROUP = "GROUP";
    private TestType test;
    private String cuType;
    private List<SearchItem> searchItems;

    public TestType getTest() {
        return this.test;
    }

    public void setTest(TestType test) {
        this.test = test;
    }

    public String getCuType() {
        return this.cuType;
    }

    public void setCuType(String cuType) {
        this.cuType = cuType;
    }

    public List<SearchItem> getSearchItems() {
        return this.searchItems;
    }

    public void setSearchItems(List<SearchItem> searchItems) {
        this.searchItems = searchItems;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("test=").append((Object)this.test).append(", ");
        sb.append("cuType=").append(this.cuType).append(", ");
        sb.append("[");
        for (SearchItem item : this.searchItems) {
            sb.append(item.toString()).append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class SearchItem {
        private String field;
        private MatchType matchType;
        private String value;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.matchType != null) {
                sb.append("matchType=").append((Object)this.matchType);
            }
            if (this.value != null) {
                sb.append("value=").append(this.value);
            }
            if (this.field != null) {
                sb.append(this.field).append(",");
            }
            return sb.toString();
        }

        public String getField() {
            return this.field;
        }

        public void setField(String fields) {
            this.field = fields;
        }

        public MatchType getMatchType() {
            return this.matchType;
        }

        public void setMatchType(MatchType matchType) {
            this.matchType = matchType;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum MatchType {
        CONTAINS("contains"),
        EXACT("exact"),
        STARTSWITH("starts-with"),
        ENDSWITH("ends-with");

        String code;

        private MatchType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static MatchType fromCode(String code) {
            if (code != null) {
                for (MatchType enumm : MatchType.values()) {
                    if (!enumm.name().equalsIgnoreCase(code) && !enumm.code.equalsIgnoreCase(code)) continue;
                    return enumm;
                }
            }
            return null;
        }
    }

    public static enum TestType {
        ANY("anyof"),
        ALL("allof");

        private String code;

        private TestType(String code) {
            this.code = code;
        }

        public static TestType fromCode(String code) {
            TestType testType = ALL;
            if (code != null && code.equals(TestType.ANY.code)) {
                testType = ANY;
            }
            return testType;
        }

        public String getCode() {
            return this.code;
        }
    }
}

