/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.Cookie;
import io.milton.http.DateUtils;
import java.util.Date;

public class BeanCookie
implements Cookie {
    private int version;
    private final String name;
    private String value;
    private boolean secure;
    private int expiry;
    private String domain;
    private String path;
    private boolean httpOnly;

    public static String toHeader(Cookie c) {
        return BeanCookie.toHeader(c, System.currentTimeMillis());
    }

    public static String toHeader(Cookie c, long nowMs) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getName()).append("=").append(c.getValue());
        if (c.getDomain() != null && c.getDomain().length() > 0) {
            sb.append("; Domain=").append(c.getDomain());
        }
        if (c.getPath() != null && c.getPath().length() > 0) {
            sb.append("; Path=").append(c.getPath());
        }
        if (c.getExpiry() > 0) {
            long expiryMs = nowMs + (long)(c.getExpiry() * 1000);
            Date date = new Date(expiryMs);
            String sDate = DateUtils.formatForCookieExpiry(date);
            sb.append("; Expires=").append(sDate);
        }
        if (c.getSecure()) {
            sb.append("; Secure");
        }
        if (c.isHttpOnly()) {
            sb.append("; HttpOnly");
        }
        return sb.toString();
    }

    public BeanCookie(String name) {
        this.name = name;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean getSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public int getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }
}

