/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.Factory;
import io.milton.context.SingletonFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryCatalog {
    private static final Logger log = LoggerFactory.getLogger(FactoryCatalog.class);
    public Map<Class, Factory> factoriesByClass = new HashMap<Class, Factory>();
    public Map<String, Factory> factoriesById = new HashMap<String, Factory>();
    public List<Factory> factories = new ArrayList<Factory>();
    public Map<String, String> keys = new HashMap<String, String>();
    public File configFile;

    public void setKeys(Map<String, String> mapOfKeys) {
        for (Map.Entry<String, String> entry : mapOfKeys.entrySet()) {
            this.addKey(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getKeys() {
        return this.keys;
    }

    public List<Factory> getFactories() {
        return this.factories;
    }

    public void setFactories(List<Factory> list) {
        for (Factory f : list) {
            this.addFactory(f);
        }
    }

    public void setSingletons(List<Object> list) {
        for (Object single : list) {
            SingletonFactory f = new SingletonFactory();
            f.setBean(single);
            this.addFactory(f);
        }
    }

    public void addFactory(Factory factory) {
        log.debug("addFactory: " + factory.getClass());
        if (factory.keyClasses() != null) {
            for (Class c : factory.keyClasses()) {
                if (this.factoriesByClass.containsKey(c)) continue;
                log.debug("    " + c.getCanonicalName());
                this.factoriesByClass.put(c, factory);
            }
        }
        if (factory.keyIds() != null) {
            for (String id : factory.keyIds()) {
                if (this.factoriesById.containsKey(id)) continue;
                this.factoriesById.put(id, factory);
            }
        }
        this.factories.add(factory);
    }

    public Factory get(Class c) throws IllegalArgumentException {
        Factory factory = this.factoriesByClass.get(c);
        if (factory == null) {
            log.warn("No factory found for: " + c.getCanonicalName());
            for (Class cc : this.factoriesByClass.keySet()) {
                log.warn("  key: " + cc.getCanonicalName());
            }
            return null;
        }
        return factory;
    }

    public Factory get(String id) {
        Factory factory = this.factoriesById.get(id);
        if (factory == null) {
            return null;
        }
        return factory;
    }

    public void destroy() {
        log.debug("destroy FactoryCatalog");
        for (Factory f : this.factories) {
            log.debug("destroying " + f.getClass().getName());
            f.destroy();
        }
    }

    public void addKey(String key, String value) {
        this.keys.put(key, value);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }
}

