/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.ContentTypeService;
import io.milton.common.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultContentTypeService
implements ContentTypeService {
    private final Map<String, List<String>> mapOfContentTypes;

    public DefaultContentTypeService(Map<String, List<String>> mapOfContentTypes) {
        this.mapOfContentTypes = mapOfContentTypes;
    }

    public DefaultContentTypeService() {
        this.mapOfContentTypes = new ConcurrentHashMap<String, List<String>>();
        Properties p = new Properties();
        InputStream in = this.getClass().getResourceAsStream("/mime-types.properties");
        if (in != null) {
            try {
                p.load(in);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            for (String extension : p.stringPropertyNames()) {
                String v = p.getProperty(extension);
                String[] contentTypes = v.split(",");
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(contentTypes));
                this.mapOfContentTypes.put(extension, list);
            }
        } else {
            throw new RuntimeException("Couldnt find properties file to load from classpath: mime-types.properties");
        }
    }

    @Override
    public List<String> findContentTypes(String name) {
        String ext = FileUtils.getExtension(name);
        if (ext == null || ext.length() == 0) {
            return null;
        }
        ext = ext.toLowerCase();
        return this.mapOfContentTypes.get(ext);
    }

    @Override
    public String getPreferedMimeType(String accept, List<String> canProvide) {
        if (canProvide == null) {
            return null;
        }
        if (canProvide.isEmpty()) {
            return null;
        }
        if (canProvide.size() == 1) {
            return canProvide.get(0);
        }
        if (accept == null || accept.length() == 0 || accept.equals("*/*")) {
            return canProvide.get(0);
        }
        String s = this.getBestMatch(accept = this.stripQop(accept), canProvide);
        if (s != null) {
            return s;
        }
        if (canProvide.isEmpty()) {
            return null;
        }
        String ct = canProvide.get(0);
        return this.stripQop(ct);
    }

    @Override
    public String getPreferedMimeType(List<String> accepts, List<String> canProvide) {
        if (canProvide == null) {
            return null;
        }
        if (canProvide.isEmpty()) {
            return null;
        }
        if (canProvide.size() == 1) {
            return canProvide.get(0);
        }
        if (accepts == null || accepts.isEmpty()) {
            return canProvide.get(0);
        }
        for (String accept : accepts) {
            String best = this.getBestMatch(accept = this.stripQop(accept), canProvide);
            if (best == null) continue;
            return best;
        }
        return null;
    }

    private String stripQop(String s) {
        if (s.contains(";")) {
            int pos = s.indexOf(";");
            s = s.substring(0, pos);
        }
        return s;
    }

    private String getBestMatch(String accept, List<String> canProvideList) {
        for (String cp : canProvideList) {
            if (!(cp = this.stripQop(cp)).contains(accept) && !cp.equals(accept)) continue;
            return cp;
        }
        return null;
    }
}

