/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.pagination;

import com.spectralogic.ds3client.exceptions.UnableToConvertToCommonPrefixesException;
import com.spectralogic.ds3client.exceptions.UnableToConvertToContentsException;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.User;
import com.spectralogic.ds3client.models.common.CommonPrefixes;
import java.util.Date;

public class FileSystemKey {
    private final String prefix;
    private final String eTag;
    private final String key;
    private final Date lastModified;
    private final User owner;
    private final Long size;
    private final String storageClass;

    private FileSystemKey(String prefixString) {
        this.prefix = prefixString;
        this.eTag = null;
        this.key = null;
        this.lastModified = null;
        this.owner = null;
        this.size = null;
        this.storageClass = null;
    }

    public FileSystemKey(CommonPrefixes commonPrefixes) {
        this(commonPrefixes.getPrefix());
    }

    private FileSystemKey(String eTag, String key, Date lastModified, User owner, long size, String storageClass) {
        this.prefix = null;
        this.eTag = eTag;
        this.key = key;
        this.lastModified = lastModified;
        this.owner = owner;
        this.size = size;
        this.storageClass = storageClass;
    }

    public FileSystemKey(Contents contents) {
        this(contents.getETag(), contents.getKey(), contents.getLastModified(), contents.getOwner(), contents.getSize(), contents.getStorageClass());
    }

    public boolean isPrefix() {
        return this.prefix != null;
    }

    public boolean isContents() {
        return this.prefix == null;
    }

    public CommonPrefixes toCommonPrefixes() throws RuntimeException {
        if (this.isContents()) {
            throw new UnableToConvertToCommonPrefixesException("Could not create a CommonPrefix");
        }
        CommonPrefixes commonPrefixes = new CommonPrefixes();
        commonPrefixes.setPrefix(this.prefix);
        return commonPrefixes;
    }

    public Contents toContents() throws RuntimeException {
        if (this.isPrefix()) {
            throw new UnableToConvertToContentsException("Could not create a Contents");
        }
        Contents contents = new Contents();
        contents.setETag(this.eTag);
        contents.setKey(this.key);
        contents.setLastModified(this.lastModified);
        contents.setOwner(this.owner);
        contents.setSize(this.size);
        contents.setStorageClass(this.storageClass);
        return contents;
    }

    public String getName() {
        return this.isPrefix() ? this.prefix : this.key;
    }
}

