/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class RawImportTapeSpectraS3Request
extends AbstractRequest {
    private final String tapeId;
    private final String bucketId;
    private String storageDomainId;
    private Priority taskPriority;

    public RawImportTapeSpectraS3Request(String bucketId, UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.bucketId = bucketId;
        this.getQueryParams().put("operation", "import");
        this.updateQueryParam("bucket_id", bucketId);
    }

    public RawImportTapeSpectraS3Request(String bucketId, String tapeId) {
        this.tapeId = tapeId;
        this.bucketId = bucketId;
        this.getQueryParams().put("operation", "import");
        this.updateQueryParam("bucket_id", bucketId);
    }

    public RawImportTapeSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public RawImportTapeSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public RawImportTapeSpectraS3Request withTaskPriority(Priority taskPriority) {
        this.taskPriority = taskPriority;
        this.updateQueryParam("task_priority", taskPriority);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape/" + this.tapeId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public Priority getTaskPriority() {
        return this.taskPriority;
    }
}

