/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataReplicationRuleType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutDs3DataReplicationRuleSpectraS3Request
extends AbstractRequest {
    private final String dataPolicyId;
    private final String targetId;
    private final DataReplicationRuleType type;
    private boolean replicateDeletes;
    private String targetDataPolicy;

    public PutDs3DataReplicationRuleSpectraS3Request(UUID dataPolicyId, UUID targetId, DataReplicationRuleType type) {
        this.dataPolicyId = dataPolicyId.toString();
        this.targetId = targetId.toString();
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("target_id", targetId);
        this.updateQueryParam("type", type);
    }

    public PutDs3DataReplicationRuleSpectraS3Request(String dataPolicyId, String targetId, DataReplicationRuleType type) {
        this.dataPolicyId = dataPolicyId;
        this.targetId = targetId;
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("target_id", targetId);
        this.updateQueryParam("type", type);
    }

    public PutDs3DataReplicationRuleSpectraS3Request withReplicateDeletes(boolean replicateDeletes) {
        this.replicateDeletes = replicateDeletes;
        this.updateQueryParam("replicate_deletes", replicateDeletes);
        return this;
    }

    public PutDs3DataReplicationRuleSpectraS3Request withTargetDataPolicy(String targetDataPolicy) {
        this.targetDataPolicy = targetDataPolicy;
        this.updateQueryParam("target_data_policy", targetDataPolicy);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/ds3_data_replication_rule";
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public DataReplicationRuleType getType() {
        return this.type;
    }

    public boolean getReplicateDeletes() {
        return this.replicateDeletes;
    }

    public String getTargetDataPolicy() {
        return this.targetDataPolicy;
    }
}

