/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutDs3DataReplicationRuleSpectraS3Response;
import com.spectralogic.ds3client.models.Ds3DataReplicationRule;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutDs3DataReplicationRuleSpectraS3ResponseParser
extends AbstractResponseParser<PutDs3DataReplicationRuleSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutDs3DataReplicationRuleSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        Ds3DataReplicationRule result = XmlOutput.fromXml(inputStream, Ds3DataReplicationRule.class);
                        PutDs3DataReplicationRuleSpectraS3Response putDs3DataReplicationRuleSpectraS3Response = new PutDs3DataReplicationRuleSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putDs3DataReplicationRuleSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

