/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;

public class WriteAclWorker
extends Worker<Boolean> {
    private final List<Path> files;
    private final Acl acl;
    private final Worker.RecursiveCallback<Acl> callback;
    private final ProgressListener listener;

    public WriteAclWorker(List<Path> files, Acl acl, boolean recursive, ProgressListener listener) {
        this(files, acl, new BooleanRecursiveCallback<Acl>(recursive), listener);
    }

    public WriteAclWorker(List<Path> files, Acl acl, Worker.RecursiveCallback<Acl> callback, ProgressListener listener) {
        this.files = files;
        this.acl = acl;
        this.callback = callback;
        this.listener = listener;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        AclPermission feature = session.getFeature(AclPermission.class);
        for (Path file : this.files) {
            this.write(session, feature, file);
        }
        return true;
    }

    protected void write(Session<?> session, AclPermission feature, Path file) throws BackgroundException {
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), file.getName(), this.acl));
        feature.setPermission(file, this.acl);
        file.attributes().setAcl(this.acl);
        if (!file.isVolume() && file.isDirectory() && this.callback.recurse(file, this.acl)) {
            for (Path child : session.getFeature(ListService.class).list(file, new WorkerListProgressListener(this, this.listener))) {
                this.write(session, feature, child);
            }
        }
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), this.toString(this.files), this.acl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteAclWorker that = (WriteAclWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteAclWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

