/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.normalizer;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.transfer.normalizer.RootPathsNormalizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CopyRootPathsNormalizer
implements RootPathsNormalizer<Map<Path, Path>> {
    private static final Logger log = Logger.getLogger(CopyRootPathsNormalizer.class);

    @Override
    public Map<Path, Path> normalize(Map<Path, Path> files) {
        HashMap<Path, Path> normalized = new HashMap<Path, Path>();
        Iterator<Path> sourcesIter = files.keySet().iterator();
        Iterator<Path> destinationsIter = files.values().iterator();
        while (sourcesIter.hasNext()) {
            Path source = sourcesIter.next();
            Path destination = destinationsIter.next();
            boolean duplicate = false;
            Iterator normalizedIter = normalized.keySet().iterator();
            while (normalizedIter.hasNext()) {
                Path n = (Path)normalizedIter.next();
                if (source.isChild(n)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Remove path %s already included by directory", source.getAbsolute()));
                    }
                    duplicate = true;
                    break;
                }
                if (!n.isChild(source)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Remove path %s already included by directory", n.getAbsolute()));
                }
                normalizedIter.remove();
            }
            if (duplicate) continue;
            normalized.put(source, destination);
        }
        return normalized;
    }
}

