/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.ExecutorServiceThreadPool;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.threading.ThreadPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultThreadPool
extends ExecutorServiceThreadPool {
    public DefaultThreadPool() {
        this(PreferencesFactory.get().getInteger("threading.pool.size.max"));
    }

    public DefaultThreadPool(int size) {
        this("background", size);
    }

    public DefaultThreadPool(String prefix) {
        this(prefix, PreferencesFactory.get().getInteger("threading.pool.size.max"));
    }

    public DefaultThreadPool(String prefix, int size) {
        this(prefix, size, new LoggingUncaughtExceptionHandler());
    }

    public DefaultThreadPool(int size, Thread.UncaughtExceptionHandler handler) {
        this("background", size, handler);
    }

    public DefaultThreadPool(String prefix, int size, Thread.UncaughtExceptionHandler handler) {
        this(prefix, size, ThreadPool.Priority.norm, handler);
    }

    public DefaultThreadPool(String prefix, int size, ThreadPool.Priority priority, Thread.UncaughtExceptionHandler handler) {
        super(DefaultThreadPool.createExecutor(prefix, size, priority, handler));
    }

    public static ThreadPoolExecutor createExecutor(String prefix, int size, ThreadPool.Priority priority, final Thread.UncaughtExceptionHandler handler) {
        return new ThreadPoolExecutor(size, size, PreferencesFactory.get().getLong("threading.pool.keepalive.seconds"), TimeUnit.SECONDS, new LinkedBlockingQueue(), (ThreadFactory)new NamedThreadFactory(prefix, priority, handler)){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    handler.uncaughtException(Thread.currentThread(), t);
                }
            }
        };
    }
}

